/*
 * Decompiled with CFR 0.152.
 */
package sourceview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.IOException;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import net.sourceforge.jsxe.ActionManager;
import net.sourceforge.jsxe.DocumentBuffer;
import net.sourceforge.jsxe.EBListener;
import net.sourceforge.jsxe.EBMessage;
import net.sourceforge.jsxe.EditBus;
import net.sourceforge.jsxe.ViewPlugin;
import net.sourceforge.jsxe.dom.AdapterNode;
import net.sourceforge.jsxe.dom.XMLDocument;
import net.sourceforge.jsxe.dom.XMLDocumentListener;
import net.sourceforge.jsxe.gui.DocumentView;
import net.sourceforge.jsxe.gui.Messages;
import net.sourceforge.jsxe.jsXe;
import net.sourceforge.jsxe.msg.PropertyChanged;
import net.sourceforge.jsxe.util.Log;
import net.sourceforge.jsxe.util.MiscUtilities;
import org.syntax.jedit.InputHandler;
import org.syntax.jedit.JEditTextArea;
import org.syntax.jedit.SyntaxStyle;
import org.syntax.jedit.TextAreaPainter;
import org.syntax.jedit.tokenmarker.XMLTokenMarker;
import sourceview.SourceViewDocument;
import sourceview.SourceViewOptionPane;
import sourceview.SourceViewPlugin;
import sourceview.SourceViewSearchDialog;

public class SourceView
extends JPanel
implements DocumentView,
EBListener {
    public static final String SOFT_TABS = "sourceview.soft.tabs";
    public static final String LAST_FIND_STRING = "sourceview.last.find.string";
    public static final String END_OF_LINE_MARKS = "sourceview.end-of-line-markers";
    private SourceViewXMLDocumentListener docListener = new SourceViewXMLDocumentListener();
    private DocumentBuffer m_document;
    private JEditTextArea m_textarea;
    private String m_searchString;
    private String m_replaceString;
    private SourceViewPlugin m_plugin;
    private JMenu m_editMenu;

    public SourceView(DocumentBuffer document, SourceViewPlugin plugin) throws IOException {
        this.m_plugin = plugin;
        this.m_textarea = new JEditTextArea();
        InputHandler handler = this.m_textarea.getInputHandler();
        handler.addKeyBinding("ENTER", new SourceViewEnter());
        handler.addKeyBinding("TAB", new SourceViewTab());
        this.m_textarea.setInputHandler(handler);
        TextAreaPainter painter = this.m_textarea.getPainter();
        painter.setEOLMarkersPainted(jsXe.getBooleanProperty((String)END_OF_LINE_MARKS, (boolean)true));
        painter.setStyles(new SyntaxStyle[]{SourceViewOptionPane.parseStyle(jsXe.getProperty((String)"sourceview.text.color")), SourceViewOptionPane.parseStyle(jsXe.getProperty((String)"sourceview.comment.color")), SourceViewOptionPane.parseStyle(jsXe.getProperty((String)"sourceview.doctype.color")), SourceViewOptionPane.parseStyle(jsXe.getProperty((String)"sourceview.attribute.value.color")), SourceViewOptionPane.parseStyle(jsXe.getProperty((String)"sourceview.attribute.value.color")), SourceViewOptionPane.parseStyle(jsXe.getProperty((String)"sourceview.cdata.color")), SourceViewOptionPane.parseStyle(jsXe.getProperty((String)"sourceview.entity.reference.color")), SourceViewOptionPane.parseStyle(jsXe.getProperty((String)"sourceview.element.color")), SourceViewOptionPane.parseStyle(jsXe.getProperty((String)"sourceview.attribute.color")), SourceViewOptionPane.parseStyle(jsXe.getProperty((String)"sourceview.processing.instruction.color")), SourceViewOptionPane.parseStyle(jsXe.getProperty((String)"sourceview.namespace.prefix.color")), SourceViewOptionPane.parseStyle(jsXe.getProperty((String)"sourceview.markup.color")), SourceViewOptionPane.parseStyle(jsXe.getProperty((String)"sourceview.invalid.color"))});
        this.m_textarea.setCaretPosition(0);
        this.m_textarea.setName("SourceTextArea");
        this.m_textarea.putClientProperty("InputHandler.homeEnd", Boolean.TRUE);
        JPopupMenu popup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem(ActionManager.getAction((String)"cut"));
        popup.add(menuItem);
        menuItem = new JMenuItem(ActionManager.getAction((String)"copy"));
        popup.add(menuItem);
        menuItem = new JMenuItem(ActionManager.getAction((String)"paste"));
        popup.add(menuItem);
        popup.addSeparator();
        menuItem = new JMenuItem(ActionManager.getAction((String)"find"));
        popup.add(menuItem);
        menuItem = new JMenuItem(ActionManager.getAction((String)"findnext"));
        popup.add(menuItem);
        this.m_textarea.setRightClickPopup(popup);
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_textarea, "Center");
        this.m_editMenu = new JMenu(Messages.getMessage((String)"Edit.Menu"));
        this.m_editMenu.setMnemonic('E');
        menuItem = new JMenuItem(ActionManager.getAction((String)"cut"));
        this.m_editMenu.add(menuItem);
        menuItem = new JMenuItem(ActionManager.getAction((String)"copy"));
        this.m_editMenu.add(menuItem);
        menuItem = new JMenuItem(ActionManager.getAction((String)"paste"));
        this.m_editMenu.add(menuItem);
        this.m_editMenu.addSeparator();
        menuItem = new JMenuItem(ActionManager.getAction((String)"find"));
        this.m_editMenu.add(menuItem);
        menuItem = new JMenuItem(ActionManager.getAction((String)"findnext"));
        this.m_editMenu.add(menuItem);
        this.setDocumentBuffer(document);
        this.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent e) {
            }

            public void componentMoved(ComponentEvent e) {
            }

            public void componentResized(ComponentEvent e) {
            }

            public void componentShown(ComponentEvent e) {
                SourceView.this.m_textarea.requestFocus();
                SourceView.this.removeComponentListener(this);
            }
        });
        EditBus.addToBus((EBListener)this);
    }

    public void handleMessage(EBMessage message) {
        if (message instanceof PropertyChanged) {
            String key = ((PropertyChanged)message).getKey();
            TextAreaPainter painter = this.getTextArea().getPainter();
            if (key.equals("source.end-of-line-markers")) {
                painter.setEOLMarkersPainted(jsXe.getBooleanProperty((String)"source.end-of-line-markers", (boolean)false));
            }
            if (key.startsWith("source.") && key.endsWith(".color")) {
                painter.setStyles(new SyntaxStyle[]{SourceViewOptionPane.parseStyle(jsXe.getProperty((String)"source.text.color")), SourceViewOptionPane.parseStyle(jsXe.getProperty((String)"source.comment.color")), SourceViewOptionPane.parseStyle(jsXe.getProperty((String)"source.doctype.color")), SourceViewOptionPane.parseStyle(jsXe.getProperty((String)"source.attribute.value.color")), SourceViewOptionPane.parseStyle(jsXe.getProperty((String)"source.attribute.value.color")), SourceViewOptionPane.parseStyle(jsXe.getProperty((String)"source.cdata.color")), SourceViewOptionPane.parseStyle(jsXe.getProperty((String)"source.entity.reference.color")), SourceViewOptionPane.parseStyle(jsXe.getProperty((String)"source.element.color")), SourceViewOptionPane.parseStyle(jsXe.getProperty((String)"source.attribute.color")), SourceViewOptionPane.parseStyle(jsXe.getProperty((String)"source.processing.instruction.color")), SourceViewOptionPane.parseStyle(jsXe.getProperty((String)"source.namespace.prefix.color")), SourceViewOptionPane.parseStyle(jsXe.getProperty((String)"source.markup.color")), SourceViewOptionPane.parseStyle(jsXe.getProperty((String)"source.invalid.color"))});
            }
        }
    }

    public JEditTextArea getTextArea() {
        return this.m_textarea;
    }

    public static String getHumanReadableName() {
        return "Source View";
    }

    public boolean close() {
        SourceViewSearchDialog dialog = SourceViewSearchDialog.getSearchDialog();
        if (dialog != null) {
            dialog.dispose();
        }
        this.m_document.removeXMLDocumentListener((XMLDocumentListener)this.docListener);
        return true;
    }

    public Component getDocumentViewComponent() {
        return this;
    }

    public JMenu[] getMenus() {
        return new JMenu[]{this.m_editMenu};
    }

    public DocumentBuffer getDocumentBuffer() {
        return this.m_document;
    }

    public ViewPlugin getViewPlugin() {
        return this.m_plugin;
    }

    public void setDocumentBuffer(DocumentBuffer document) throws IOException {
        if (this.m_document != null) {
            this.m_document.removeXMLDocumentListener((XMLDocumentListener)this.docListener);
        }
        this.ensureDefaultProps(document);
        this.m_document = document;
        this.m_textarea.setDocument(new SourceViewDocument((XMLDocument)this.m_document));
        this.m_textarea.setTokenMarker(new XMLTokenMarker());
        try {
            this.m_textarea.getDocument().putProperty("tabSize", Integer.valueOf(document.getProperty("indent", "4")));
        }
        catch (NumberFormatException e) {
            Log.log((int)7, (Object)this, (Object)e.getMessage());
        }
        this.m_document.addXMLDocumentListener((XMLDocumentListener)this.docListener);
    }

    public boolean goToLine(int lineNo) {
        return false;
    }

    private void ensureDefaultProps(DocumentBuffer document) {
    }

    private class SourceViewTab
    implements ActionListener {
        private SourceViewTab() {
        }

        public void actionPerformed(ActionEvent evt) {
            if (!SourceView.this.m_textarea.isEditable()) {
                SourceView.this.m_textarea.getToolkit().beep();
                return;
            }
            boolean softTabs = Boolean.valueOf(SourceView.this.m_document.getProperty("soft-tabs", "false"));
            if (softTabs) {
                try {
                    int indent = Integer.parseInt(SourceView.this.m_document.getProperty("indent"));
                    StringBuffer tab = new StringBuffer();
                    for (int i = 0; i < indent; ++i) {
                        tab.append(" ");
                    }
                    SourceView.this.m_textarea.overwriteSetSelectedText(tab.toString());
                }
                catch (NumberFormatException nfe) {
                    Log.log((int)9, (Object)this, (Object)nfe);
                }
            } else {
                SourceView.this.m_textarea.overwriteSetSelectedText("\t");
            }
        }
    }

    private class SourceViewEnter
    implements ActionListener {
        private SourceViewEnter() {
        }

        public void actionPerformed(ActionEvent evt) {
            if (!SourceView.this.m_textarea.isEditable()) {
                SourceView.this.m_textarea.getToolkit().beep();
                return;
            }
            SourceView.this.m_textarea.setSelectedText("\n" + this.getLastIndent());
        }

        private String getLastIndent() {
            boolean softTabs = Boolean.valueOf(SourceView.this.m_document.getProperty("soft-tabs", "false"));
            int tabWidth = Integer.parseInt(SourceView.this.m_document.getProperty("indent"));
            StringBuffer indent = new StringBuffer();
            for (int line = SourceView.this.m_textarea.getCaretLine(); line >= 1; --line) {
                String text = SourceView.this.m_textarea.getLineText(line);
                for (int i = 0; i < text.length(); ++i) {
                    char current = text.charAt(i);
                    if (current == ' ' || current == '\t' || current == '\n') continue;
                    int ws = MiscUtilities.getLeadingWhiteSpaceWidth((String)text, (int)tabWidth);
                    return MiscUtilities.createWhiteSpace((int)ws, (int)(softTabs ? 0 : tabWidth));
                }
            }
            return "";
        }
    }

    private class SourceViewXMLDocumentListener
    implements XMLDocumentListener {
        private SourceViewXMLDocumentListener() {
        }

        public void propertyChanged(XMLDocument source, String key, String oldValue) {
            if (key.equals("indent")) {
                try {
                    SourceView.this.m_textarea.getDocument().putProperty("tabSize", Integer.valueOf(source.getProperty("indent", "4")));
                    SourceView.this.m_textarea.updateUI();
                }
                catch (NumberFormatException e) {
                    Log.log((int)7, (Object)this, (Object)e.getMessage());
                }
            }
        }

        public void structureChanged(XMLDocument source, AdapterNode location) {
        }
    }
}

