/*
 * Decompiled with CFR 0.152.
 */
package sourceview;

import java.awt.Toolkit;
import java.io.IOException;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import net.sourceforge.jsxe.dom.XMLDocument;
import net.sourceforge.jsxe.util.Log;
import org.syntax.jedit.SyntaxDocument;
import org.w3c.dom.DOMException;

public class SourceViewDocument
extends SyntaxDocument {
    private XMLDocument m_document;

    protected SourceViewDocument(XMLDocument document) throws IOException {
        this.m_document = document;
        if (document != null) {
            try {
                super.insertString(0, document.getText(0, document.getLength()), null);
            }
            catch (BadLocationException ble) {
                Log.log((int)9, (Object)this, (Object)ble);
            }
        }
    }

    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        try {
            super.insertString(offs, str, a);
            this.m_document.insertText(offs, str);
        }
        catch (DOMException dome) {
            Log.log((int)9, (Object)this, (Object)dome);
            Toolkit.getDefaultToolkit().beep();
        }
        catch (IOException ioe) {
            Log.log((int)9, (Object)this, (Object)ioe);
        }
    }

    public void remove(int offs, int len) throws BadLocationException {
        try {
            super.remove(offs, len);
            this.m_document.removeText(offs, len);
        }
        catch (DOMException dome) {
            Log.log((int)9, (Object)this, (Object)dome);
            Toolkit.getDefaultToolkit().beep();
        }
        catch (IOException ioe) {
            Log.log((int)9, (Object)this, (Object)ioe);
        }
    }
}

