/*
 * Decompiled with CFR 0.152.
 */
package sourceview;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Comparator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.sourceforge.jsxe.DocumentBuffer;
import net.sourceforge.jsxe.OperatingSystem;
import net.sourceforge.jsxe.gui.EnhancedDialog;
import net.sourceforge.jsxe.gui.Messages;
import net.sourceforge.jsxe.jsXe;
import net.sourceforge.jsxe.options.AbstractOptionPane;
import net.sourceforge.jsxe.util.MiscUtilities;
import org.syntax.jedit.SyntaxStyle;

public class SourceViewOptionPane
extends AbstractOptionPane {
    private StyleTableModel styleModel;
    private JTable styleTable;
    private JCheckBox m_endOfLineMarkCheckBox;

    public SourceViewOptionPane(DocumentBuffer buffer) {
        super("sourceview");
    }

    protected void _init() {
        this.setLayout(new BorderLayout(6, 6));
        this.add("Center", this.createStyleTableScroller());
        this.m_endOfLineMarkCheckBox = new JCheckBox(Messages.getMessage((String)"SourceView.Options.EndOfLineMarker"), jsXe.getBooleanProperty((String)"source.end-of-line-markers", (boolean)true));
        this.m_endOfLineMarkCheckBox.setToolTipText(Messages.getMessage((String)"SourceView.Options.EndOfLineMarker.Tooltip"));
        this.add("South", this.m_endOfLineMarkCheckBox);
    }

    protected void _save() {
        this.styleModel.save();
        jsXe.setBooleanProperty((String)"source.end-of-line-markers", (boolean)this.m_endOfLineMarkCheckBox.isSelected());
    }

    public String getTitle() {
        return Messages.getMessage((String)"SourceView.Options.Title");
    }

    public static SyntaxStyle parseStyle(String str) throws IllegalArgumentException {
        Color fgColor = Color.black;
        Object bgColor = null;
        boolean italic = false;
        boolean bold = false;
        StringTokenizer st = new StringTokenizer(str);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.startsWith("color:")) {
                fgColor = SourceViewOptionPane.parseColor(s.substring(6), Color.black);
                continue;
            }
            if (s.startsWith("style:")) {
                for (int i = 6; i < s.length(); ++i) {
                    if (s.charAt(i) == 'i') {
                        italic = true;
                        continue;
                    }
                    if (s.charAt(i) == 'b') {
                        bold = true;
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid style: " + s);
                }
                continue;
            }
            throw new IllegalArgumentException("Invalid directive: " + s);
        }
        return new SyntaxStyle(fgColor, italic, bold);
    }

    public static Color parseColor(String name, Color defaultColor) {
        if (name == null) {
            return defaultColor;
        }
        if (name.startsWith("#")) {
            try {
                return Color.decode(name);
            }
            catch (NumberFormatException nf) {
                return defaultColor;
            }
        }
        if ("red".equals(name)) {
            return Color.red;
        }
        if ("green".equals(name)) {
            return Color.green;
        }
        if ("blue".equals(name)) {
            return Color.blue;
        }
        if ("yellow".equals(name)) {
            return Color.yellow;
        }
        if ("orange".equals(name)) {
            return Color.orange;
        }
        if ("white".equals(name)) {
            return Color.white;
        }
        if ("lightGray".equals(name)) {
            return Color.lightGray;
        }
        if ("gray".equals(name)) {
            return Color.gray;
        }
        if ("darkGray".equals(name)) {
            return Color.darkGray;
        }
        if ("black".equals(name)) {
            return Color.black;
        }
        if ("cyan".equals(name)) {
            return Color.cyan;
        }
        if ("magenta".equals(name)) {
            return Color.magenta;
        }
        if ("pink".equals(name)) {
            return Color.pink;
        }
        return defaultColor;
    }

    private static JDialog getParentDialog(Component c) {
        Container p;
        for (p = c.getParent(); p != null && !(p instanceof JDialog); p = p.getParent()) {
        }
        return p instanceof JDialog ? (JDialog)p : null;
    }

    private static String getStyleString(SyntaxStyle style) {
        StringBuffer buf = new StringBuffer();
        if (style.getColor() != null) {
            buf.append("color:" + SourceViewOptionPane.getColorHexString(style.getColor()));
        }
        if (!style.isPlain()) {
            buf.append(" style:" + (style.isItalic() ? "i" : "") + (style.isBold() ? "b" : ""));
        }
        return buf.toString();
    }

    private JScrollPane createStyleTableScroller() {
        this.styleModel = this.createStyleTableModel();
        this.styleTable = new JTable(this.styleModel);
        this.styleTable.setRowSelectionAllowed(false);
        this.styleTable.setColumnSelectionAllowed(false);
        this.styleTable.setCellSelectionEnabled(false);
        this.styleTable.getTableHeader().setReorderingAllowed(false);
        this.styleTable.addMouseListener(new MouseHandler());
        TableColumnModel tcm = this.styleTable.getColumnModel();
        TableColumn styleColumn = tcm.getColumn(1);
        styleColumn.setCellRenderer(new StyleTableModel.StyleRenderer());
        Dimension d = this.styleTable.getPreferredSize();
        d.height = Math.min(d.height, 100);
        JScrollPane scroller = new JScrollPane(this.styleTable);
        scroller.setPreferredSize(d);
        return scroller;
    }

    private StyleTableModel createStyleTableModel() {
        return new StyleTableModel();
    }

    private static String getColorHexString(Color c) {
        String colString = Integer.toHexString(c.getRGB() & 0xFFFFFF);
        return "#000000".substring(0, 7 - colString.length()).concat(colString);
    }

    public static class ColorWellButton
    extends JButton {
        public ColorWellButton(Color color) {
            this.setIcon(new ColorWell(color));
            this.setMargin(new Insets(2, 2, 2, 2));
            this.addActionListener(new ActionHandler());
            if (OperatingSystem.isMacOSLF()) {
                this.putClientProperty("JButton.buttonType", "toolbar");
            }
        }

        public Color getSelectedColor() {
            return ((ColorWell)this.getIcon()).color;
        }

        public void setSelectedColor(Color color) {
            ((ColorWell)this.getIcon()).color = color;
            this.repaint();
        }

        private class ColorPickerDialog
        extends EnhancedDialog
        implements ActionListener {
            private JColorChooser chooser;
            private JButton ok;
            private JButton cancel;

            public ColorPickerDialog(Frame parent, String title, boolean modal) {
                super(parent, title, modal);
                this.init();
            }

            public ColorPickerDialog(Dialog parent, String title, boolean modal) {
                super(parent, title, modal);
                this.getContentPane().setLayout(new BorderLayout());
                this.init();
            }

            public void ok() {
                Color c = this.chooser.getColor();
                if (c != null) {
                    ColorWellButton.this.setSelectedColor(c);
                }
                this.setVisible(false);
            }

            public void cancel() {
                this.setVisible(false);
            }

            public void actionPerformed(ActionEvent evt) {
                if (evt.getSource() == this.ok) {
                    this.ok();
                } else {
                    this.cancel();
                }
            }

            private void init() {
                Color c = ColorWellButton.this.getSelectedColor();
                this.chooser = c == null ? new JColorChooser() : new JColorChooser(c);
                this.getContentPane().add("Center", this.chooser);
                Box buttons = new Box(0);
                buttons.add(Box.createGlue());
                this.ok = new JButton(Messages.getMessage((String)"common.ok"));
                this.ok.addActionListener(this);
                buttons.add(this.ok);
                buttons.add(Box.createHorizontalStrut(6));
                this.getRootPane().setDefaultButton(this.ok);
                this.cancel = new JButton(Messages.getMessage((String)"common.cancel"));
                this.cancel.addActionListener(this);
                buttons.add(this.cancel);
                buttons.add(Box.createGlue());
                this.getContentPane().add("South", buttons);
                this.pack();
                this.setLocationRelativeTo(this.getParent());
            }
        }

        class ActionHandler
        implements ActionListener {
            ActionHandler() {
            }

            public void actionPerformed(ActionEvent evt) {
                JDialog parent = SourceViewOptionPane.getParentDialog(ColorWellButton.this);
                ColorPickerDialog dialog = parent != null ? new ColorPickerDialog(parent, Messages.getMessage((String)"SourceView.ColorChooser.Title"), true) : new ColorPickerDialog(JOptionPane.getFrameForComponent(ColorWellButton.this), Messages.getMessage((String)"SourceView.ColorChooser.Title"), true);
                ((Window)((Object)dialog)).pack();
                ((Dialog)((Object)dialog)).show();
            }
        }

        private class ColorWell
        implements Icon {
            Color color;

            ColorWell(Color color) {
                this.color = color;
            }

            public int getIconWidth() {
                return 35;
            }

            public int getIconHeight() {
                return 10;
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
                if (this.color == null) {
                    return;
                }
                g.setColor(this.color);
                g.fillRect(x, y, this.getIconWidth(), this.getIconHeight());
                g.setColor(this.color.darker());
                g.drawRect(x, y, this.getIconWidth() - 1, this.getIconHeight() - 1);
            }
        }
    }

    private static class StyleTableModel
    extends AbstractTableModel {
        private Vector styleChoices = new Vector(9);

        public StyleTableModel() {
            this.addStyleChoice("SourceView.Markup", "sourceview.markup.color");
            this.addStyleChoice("xml.namespace.prefix", "sourceview.namespace.prefix.color");
            this.addStyleChoice("xml.text", "sourceview.text.color");
            this.addStyleChoice("xml.element", "sourceview.element.color");
            this.addStyleChoice("xml.attribute", "sourceview.attribute.color");
            this.addStyleChoice("xml.attribute.value", "sourceview.attribute.value.color");
            this.addStyleChoice("xml.cdata", "sourceview.cdata.color");
            this.addStyleChoice("xml.processing.instruction", "sourceview.processing.instruction.color");
            this.addStyleChoice("xml.entity.reference", "sourceview.entity.reference.color");
            this.addStyleChoice("xml.comment", "sourceview.comment.color");
            this.addStyleChoice("xml.doctype", "sourceview.doctype.color");
            this.addStyleChoice("SourceView.Invalid", "sourceview.invalid.color");
            MiscUtilities.quicksort((Vector)this.styleChoices, (Comparator)new MiscUtilities.StringCompare());
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return this.styleChoices.size();
        }

        public Object getValueAt(int row, int col) {
            StyleChoice ch = (StyleChoice)this.styleChoices.elementAt(row);
            switch (col) {
                case 0: {
                    return ch.label;
                }
                case 1: {
                    return ch.style;
                }
            }
            return null;
        }

        public void setValueAt(Object value, int row, int col) {
            StyleChoice ch = (StyleChoice)this.styleChoices.elementAt(row);
            if (col == 1) {
                ch.style = (SyntaxStyle)value;
            }
            this.fireTableRowsUpdated(row, row);
        }

        public String getColumnName(int index) {
            switch (index) {
                case 0: {
                    return Messages.getMessage((String)"SourceView.Syntax.Object");
                }
                case 1: {
                    return Messages.getMessage((String)"SourceView.Syntax.Style");
                }
            }
            return null;
        }

        public void save() {
            for (int i = 0; i < this.styleChoices.size(); ++i) {
                StyleChoice ch = (StyleChoice)this.styleChoices.elementAt(i);
                jsXe.setProperty((String)ch.property, (String)SourceViewOptionPane.getStyleString(ch.style));
            }
        }

        private void addStyleChoice(String label, String property) {
            this.styleChoices.addElement(new StyleChoice(Messages.getMessage((String)label), property, SourceViewOptionPane.parseStyle(jsXe.getProperty((String)property, (String)"color:#000000"))));
        }

        static class StyleRenderer
        extends JLabel
        implements TableCellRenderer {
            public StyleRenderer() {
                this.setOpaque(true);
                this.setText("Hello World");
                this.setToolTipText(Messages.getMessage((String)"SourceView.Syntax.ToolTip"));
            }

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean cellHasFocus, int row, int col) {
                if (value != null) {
                    SyntaxStyle style = (SyntaxStyle)value;
                    this.setForeground(style.getColor());
                    this.setBackground(Color.WHITE);
                    this.setFont(new Font("Monospaced", (style.isItalic() ? 2 : 0) | (style.isBold() ? 1 : 0), 12));
                }
                return this;
            }
        }

        private class StyleChoice {
            String label;
            String property;
            SyntaxStyle style;

            StyleChoice(String label, String property, SyntaxStyle style) {
                this.label = label;
                this.property = property;
                this.style = style;
            }

            public String toString() {
                return this.label;
            }
        }
    }

    private static class StyleEditor
    extends EnhancedDialog
    implements ActionListener {
        private JCheckBox italics;
        private JCheckBox bold;
        private JCheckBox fgColorCheckBox;
        private ColorWellButton fgColor;
        private JButton ok;
        private JButton cancel;
        private boolean okClicked;

        public StyleEditor(Component comp, SyntaxStyle style) {
            super((Dialog)SourceViewOptionPane.getParentDialog(comp), Messages.getMessage((String)"SourceView.StyleEditor.Title"), true);
            JPanel content = new JPanel(new BorderLayout(12, 12));
            content.setBorder(new EmptyBorder(12, 12, 12, 12));
            this.setContentPane(content);
            GridBagLayout layout = new GridBagLayout();
            JPanel panel = new JPanel(layout);
            GridBagConstraints cons = new GridBagConstraints();
            cons.gridy = 0;
            cons.gridx = 0;
            cons.gridwidth = 2;
            cons.gridheight = 1;
            cons.fill = 1;
            cons.weightx = 0.0;
            this.italics = new JCheckBox(Messages.getMessage((String)"SourceView.StyleEditor.Italics"));
            this.italics.setSelected(style.isItalic());
            this.italics.setToolTipText(Messages.getMessage((String)"SourceView.StyleEditor.Italics.ToolTip"));
            layout.setConstraints(this.italics, cons);
            panel.add(this.italics);
            ++cons.gridy;
            this.bold = new JCheckBox(Messages.getMessage((String)"SourceView.StyleEditor.Bold"));
            this.bold.setSelected(style.isBold());
            this.bold.setToolTipText(Messages.getMessage((String)"SourceView.StyleEditor.Bold.ToolTip"));
            layout.setConstraints(this.bold, cons);
            panel.add(this.bold);
            ++cons.gridy;
            cons.gridwidth = 1;
            Color fg = style.getColor();
            this.fgColorCheckBox = new JCheckBox(Messages.getMessage((String)"SourceView.StyleEditor.Color"));
            this.fgColorCheckBox.setSelected(fg != null);
            this.fgColorCheckBox.addActionListener(this);
            this.fgColorCheckBox.setBorder(new EmptyBorder(0, 0, 0, 12));
            this.fgColorCheckBox.setToolTipText(Messages.getMessage((String)"SourceView.StyleEditor.Color.ToolTip"));
            layout.setConstraints(this.fgColorCheckBox, cons);
            panel.add(this.fgColorCheckBox);
            ++cons.gridx;
            this.fgColor = new ColorWellButton(fg);
            this.fgColor.setEnabled(fg != null);
            layout.setConstraints(this.fgColor, cons);
            panel.add(this.fgColor);
            content.add("Center", panel);
            Box box = new Box(0);
            box.add(Box.createGlue());
            this.ok = new JButton(Messages.getMessage((String)"common.ok"));
            box.add(this.ok);
            this.getRootPane().setDefaultButton(this.ok);
            this.ok.addActionListener(this);
            box.add(Box.createHorizontalStrut(6));
            this.cancel = new JButton(Messages.getMessage((String)"common.cancel"));
            box.add(this.cancel);
            this.cancel.addActionListener(this);
            box.add(Box.createGlue());
            content.add("South", box);
            this.pack();
            this.setLocationRelativeTo(SourceViewOptionPane.getParentDialog(comp));
            this.setResizable(false);
            this.show();
        }

        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source == this.ok) {
                this.ok();
            } else if (source == this.cancel) {
                this.cancel();
            } else if (source == this.fgColorCheckBox) {
                this.fgColor.setEnabled(this.fgColorCheckBox.isSelected());
            }
        }

        public void ok() {
            this.okClicked = true;
            this.dispose();
        }

        public void cancel() {
            this.dispose();
        }

        public SyntaxStyle getStyle() {
            if (!this.okClicked) {
                return null;
            }
            Color foreground = this.fgColorCheckBox.isSelected() ? this.fgColor.getSelectedColor() : null;
            return new SyntaxStyle(foreground, this.italics.isSelected(), this.bold.isSelected());
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent evt) {
            int row = SourceViewOptionPane.this.styleTable.rowAtPoint(evt.getPoint());
            if (row == -1) {
                return;
            }
            SyntaxStyle style = new StyleEditor((Component)((Object)SourceViewOptionPane.this), (SyntaxStyle)SourceViewOptionPane.this.styleModel.getValueAt(row, 1)).getStyle();
            if (style != null) {
                SourceViewOptionPane.this.styleModel.setValueAt(style, row, 1);
            }
        }
    }
}

