/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsxe;

import java.util.Enumeration;
import java.util.Hashtable;
import net.sourceforge.jsxe.LocalizedAction;

public class ActionSet {
    private String label;
    private Hashtable actions;

    public ActionSet() {
        this(null);
    }

    public ActionSet(String label) {
        this.label = label;
        this.actions = new Hashtable();
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void addAction(LocalizedAction action) {
        this.actions.put(action.getName(), action);
    }

    public void removeAction(String name) {
        this.actions.remove(name);
    }

    public void removeAllActions() {
        this.actions.clear();
    }

    public LocalizedAction getAction(String name) {
        return (LocalizedAction)this.actions.get(name);
    }

    public int getActionCount() {
        return this.actions.size();
    }

    public String[] getActionNames() {
        String[] retVal = new String[this.actions.size()];
        Enumeration e = this.actions.keys();
        int i = 0;
        while (e.hasMoreElements()) {
            retVal[i++] = (String)e.nextElement();
        }
        return retVal;
    }

    public LocalizedAction[] getActions() {
        LocalizedAction[] retVal = new LocalizedAction[this.actions.size()];
        Enumeration elements = this.actions.elements();
        int i = 0;
        while (elements.hasMoreElements()) {
            retVal[i++] = (LocalizedAction)elements.nextElement();
        }
        return retVal;
    }

    public boolean contains(LocalizedAction action) {
        return this.actions.contains(action);
    }

    public String toString() {
        return this.getLabel();
    }
}

