/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsxe.action;

import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.Vector;
import net.sourceforge.jsxe.DocumentBuffer;
import net.sourceforge.jsxe.LocalizedAction;
import net.sourceforge.jsxe.gui.ErrorListDialog;
import net.sourceforge.jsxe.gui.Messages;
import net.sourceforge.jsxe.gui.TabbedView;
import org.xml.sax.SAXParseException;

public class ValidationErrorsAction
extends LocalizedAction {
    public ValidationErrorsAction() {
        super("validation-errors");
    }

    public void invoke(TabbedView view, ActionEvent evt) {
        DocumentBuffer document = view.getDocumentView().getDocumentBuffer();
        Vector<String> errors = new Vector<String>();
        Iterator itr = document.getErrors().iterator();
        while (itr.hasNext()) {
            errors.add(this.formatError(document.getName(), (Exception)itr.next()));
        }
        ErrorListDialog dialog = new ErrorListDialog(view, Messages.getMessage("ValidationErrors.title"), Messages.getMessage("ValidationErrors.message"), errors, true);
    }

    private String formatError(String name, Exception e) {
        String message;
        if (e instanceof SAXParseException) {
            SAXParseException saxError = (SAXParseException)e;
            int line = saxError.getLineNumber();
            int column = saxError.getColumnNumber();
            message = name + ":" + line + ":" + column + ":" + e.getMessage();
        } else {
            message = name + ":" + e.getMessage();
        }
        return message;
    }
}

