/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsxe.dom;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import net.sourceforge.jsxe.dom.AdapterNodeListener;
import net.sourceforge.jsxe.dom.DOMSerializer;
import net.sourceforge.jsxe.dom.XMLDocument;
import net.sourceforge.jsxe.dom.completion.CompletionInfo;
import net.sourceforge.jsxe.dom.completion.ElementDecl;
import net.sourceforge.jsxe.util.Log;
import net.sourceforge.jsxe.util.MiscUtilities;
import org.apache.xerces.dom.NodeImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

public class AdapterNode {
    public static final short ATTRIBUTE_NODE = 2;
    public static final short CDATA_SECTION_NODE = 4;
    public static final short COMMENT_NODE = 8;
    public static final short DOCUMENT_FRAGMENT_NODE = 11;
    public static final short DOCUMENT_NODE = 9;
    public static final short DOCUMENT_TYPE_NODE = 10;
    public static final short ELEMENT_NODE = 1;
    public static final short ENTITY_NODE = 6;
    public static final short ENTITY_REFERENCE_NODE = 5;
    public static final short NOTATION_NODE = 12;
    public static final short PROCESSING_INSTRUCTION_NODE = 7;
    public static final short TEXT_NODE = 3;
    private AdapterNode m_parentNode;
    private XMLDocument m_rootDocument;
    private XMLDocument m_lastRootDocument;
    private ArrayList m_children = new ArrayList();
    private Node m_domNode;
    private ArrayList m_listeners = new ArrayList();
    private Properties m_props = new Properties();

    AdapterNode(Node node) {
        if (node == null) {
            throw new NullPointerException();
        }
        this.m_domNode = node;
    }

    AdapterNode(XMLDocument xmlDocument, Document document) {
        if (xmlDocument == null || document == null) {
            throw new NullPointerException();
        }
        this.m_domNode = document;
        this.m_rootDocument = xmlDocument;
    }

    AdapterNode(AdapterNode parent, Node node) {
        if (node == null) {
            throw new NullPointerException();
        }
        this.m_domNode = node;
        this.setParent(parent);
    }

    public XMLDocument getOwnerDocument() {
        return this.m_rootDocument;
    }

    public String getProperty(String key) {
        return this.m_props.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.m_props.getProperty(key, defaultValue);
    }

    public String setProperty(String key, String value) {
        Object oldValue = this.m_props.setProperty(key, value);
        if (oldValue != null) {
            return oldValue.toString();
        }
        return null;
    }

    public int index(AdapterNode child) {
        int count = this.childCount();
        for (int i = 0; i < count; ++i) {
            AdapterNode n = this.child(i);
            if (!child.equals(n)) continue;
            return i;
        }
        return -1;
    }

    public AdapterNode copy(boolean deep) {
        Node newNode = this.m_domNode.cloneNode(deep);
        AdapterNode node = new AdapterNode(newNode);
        return node;
    }

    public AdapterNode child(int index) {
        XMLDocument rootDocument = this.getOwnerDocument();
        AdapterNode child = null;
        if (index < this.m_domNode.getChildNodes().getLength()) {
            if (index < this.m_children.size()) {
                try {
                    child = (AdapterNode)this.m_children.get(index);
                    if (child == null) {
                        child = rootDocument.newAdapterNode(this, this.m_domNode.getChildNodes().item(index));
                        this.m_children.set(index, child);
                    }
                }
                catch (IndexOutOfBoundsException ioobe) {}
            } else {
                this.ensureChildrenSize(index + 1);
                child = rootDocument.newAdapterNode(this, this.m_domNode.getChildNodes().item(index));
                this.m_children.set(index, child);
            }
        }
        return child;
    }

    public int childCount() {
        NodeList childNodes = this.m_domNode.getChildNodes();
        if (childNodes != null) {
            return childNodes.getLength();
        }
        return 0;
    }

    public String getNSPrefix() {
        return this.m_domNode.getPrefix();
    }

    public void setNSPrefix(String prefix) throws DOMException {
        this.m_domNode.setPrefix(prefix);
        this.fireNamespaceChanged(this);
    }

    public String getNodeName() {
        return this.m_domNode.getNodeName();
    }

    public void setNodeName(String qualifiedName) throws DOMException {
        String oldPrefix = this.getNSPrefix();
        String oldLocalName = this.getLocalName();
        String prefix = MiscUtilities.getNSPrefixFromQualifiedName(qualifiedName);
        String localName = MiscUtilities.getLocalNameFromQualifiedName(qualifiedName);
        if (this.getNodeType() == 1) {
            this.renameElementNode(prefix, localName);
        } else if (this.getNodeType() == 7) {
            this.renamePINode(localName);
        } else {
            throw new DOMException(9, "An attempt was made to rename a node that is not supported.");
        }
        if (!MiscUtilities.equals(oldPrefix, prefix)) {
            this.fireNamespaceChanged(this);
        }
        if (!MiscUtilities.equals(oldLocalName, localName)) {
            this.fireLocalNameChanged(this);
        }
    }

    public String getLocalName() {
        return this.m_domNode.getLocalName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setLocalName(String localName) throws DOMException {
        if (this.m_domNode.getNodeType() == 1) {
            if (this.m_domNode.getLocalName().equals(localName)) return;
            this.renameElementNode(this.getNSPrefix(), localName);
            this.fireLocalNameChanged(this);
            return;
        } else if (this.m_domNode.getNodeType() == 7) {
            if (this.m_domNode.getNodeName() == localName) return;
            ProcessingInstruction newNode = this.m_domNode.getOwnerDocument().createProcessingInstruction(localName, this.m_domNode.getNodeValue());
            this.m_domNode.getParentNode().replaceChild(newNode, this.m_domNode);
            this.m_domNode = newNode;
            return;
        } else {
            if (this.m_domNode.getNodeType() != 5) throw new DOMException(9, "Renaming this node type is not supported.");
            if (this.m_domNode.getNodeName() == localName) return;
            if (!this.getOwnerDocument().entityDeclared(localName)) throw new DOMException(12, "Entity \"" + localName + "\"" + " is not declared in the Schema");
            EntityReference newNode = this.m_domNode.getOwnerDocument().createEntityReference(localName);
            this.m_domNode.getParentNode().replaceChild(newNode, this.m_domNode);
            this.m_domNode = newNode;
        }
    }

    public String getNodeValue() {
        return this.m_domNode.getNodeValue();
    }

    public void setNodeValue(String str) throws DOMException {
        if (str != null && !str.equals(this.m_domNode.getNodeValue())) {
            this.m_domNode.setNodeValue(str);
            this.fireNodeValueChanged(this);
        }
    }

    public short getNodeType() {
        return this.m_domNode.getNodeType();
    }

    public AdapterNode getParentNode() {
        return this.m_parentNode;
    }

    public NamedNodeMap getAttributes() {
        return this.m_domNode.getAttributes();
    }

    public AdapterNode addAdapterNode(String name, String value, short type, int index) throws DOMException {
        return this.addAdapterNodeAt(this.getOwnerDocument().newAdapterNode(this, name, value, type), index);
    }

    public AdapterNode addAdapterNode(AdapterNode node) throws DOMException {
        return this.addAdapterNodeAt(node, this.childCount());
    }

    public AdapterNode addAdapterNodeAt(AdapterNode node, int location) throws DOMException {
        if (node != null) {
            if (location >= 0 && location <= this.childCount()) {
                if (this.m_children.indexOf(node) == location) {
                    return node;
                }
                if (node.getNodeType() == 11) {
                    for (int i = 0; i < node.childCount(); ++i) {
                        this.addAdapterNodeAt(node.child(i), location + i);
                    }
                } else {
                    if (this.m_children.contains(node)) {
                        if (location > this.m_children.indexOf(node)) {
                            --location;
                        }
                        this.m_children.remove(node);
                    }
                    if (location >= this.m_children.size()) {
                        this.m_domNode.appendChild(node.getNode());
                        this.ensureChildrenSize(location);
                        this.m_children.add(node);
                    } else {
                        this.m_domNode.insertBefore(node.getNode(), this.child(location).getNode());
                        this.m_children.add(location, node);
                    }
                    AdapterNode previousParent = node.getParentNode();
                    if (previousParent != this && previousParent != null) {
                        previousParent.removeChild(node);
                    }
                    node.setParent(this);
                    this.fireNodeAdded(this, node);
                }
            } else {
                throw new DOMException(1, "The location to insert this node is invalid.");
            }
        }
        return node;
    }

    public void remove(AdapterNode child) throws DOMException {
        if (child != null) {
            if (this.getNodeType() == 9 && child.getNodeType() == 1) {
                throw new DOMException(9, "You cannot remove the root element node.");
            }
            if (child.getNodeType() != 10) {
                this.m_domNode.removeChild(child.getNode());
                this.m_children.remove(child);
                child.setParent(null);
                this.fireNodeRemoved(this, child);
            } else {
                throw new DOMException(9, "Cannot remove Document Type Nodes");
            }
        }
    }

    public void setAttribute(String name, String value) throws DOMException {
        if (this.m_domNode.getNodeType() == 1) {
            Element element = (Element)this.m_domNode;
            String prefix = MiscUtilities.getNSPrefixFromQualifiedName(name);
            if ("xmlns".equals(prefix) && value != null && value.equals("")) {
                throw new DOMException(14, "An attempt was made to create an empty namespace declaration");
            }
            if (prefix != null && !prefix.equals("")) {
                element.setAttributeNS(this.lookupNamespaceURI(prefix), name, value);
            } else {
                if (name != null && !name.equals("") && name.charAt(0) == ':') {
                    throw new DOMException(14, "An attribute name cannot have a ':' as the first character");
                }
                element.setAttribute(name, value);
            }
        } else {
            throw new DOMException(9, "Only Element Nodes can have attributes");
        }
        this.fireAttributeChanged(this, name);
    }

    public String getAttribute(String name) throws DOMException {
        if (this.m_domNode.getNodeType() == 1) {
            String localName = MiscUtilities.getLocalNameFromQualifiedName(name);
            String prefix = MiscUtilities.getNSPrefixFromQualifiedName(name);
            Element element = (Element)this.m_domNode;
            if (prefix != null && !prefix.equals("")) {
                return element.getAttributeNS(this.lookupNamespaceURI(prefix), localName);
            }
            return element.getAttribute(name);
        }
        throw new DOMException(9, "Only Element Nodes can have attributes");
    }

    public void removeAttributeAt(int index) throws DOMException {
        if (this.m_domNode.getNodeType() == 1) {
            Element element = (Element)this.m_domNode;
            NamedNodeMap attrs = element.getAttributes();
            if (attrs != null) {
                this.removeAttribute(attrs.item(index).getNodeName());
            }
        } else {
            throw new DOMException(9, "Only Element Nodes can have attributes");
        }
    }

    public void removeAttribute(String attr) throws DOMException {
        if (this.m_domNode.getNodeType() == 1) {
            Element element = (Element)this.m_domNode;
            String prefix = MiscUtilities.getNSPrefixFromQualifiedName(attr);
            String localName = MiscUtilities.getLocalNameFromQualifiedName(attr);
            if ("xmlns".equals(prefix)) {
                String uri = this.lookupNamespaceURI(localName);
                if (!uri.equals(element.getNamespaceURI())) {
                    NodeList list = element.getElementsByTagName("*");
                    for (int i = 0; i < list.getLength(); ++i) {
                        Node ele = list.item(i);
                        if (uri.equals(ele.getNamespaceURI())) {
                            throw new DOMException(14, "An attempt was made to remove a namespace declaration when nodes exist that use it");
                        }
                        NamedNodeMap attrs = ele.getAttributes();
                        for (int j = 0; j < attrs.getLength(); ++j) {
                            Node foundAttr = attrs.item(i);
                            if (!uri.equals(foundAttr.getNamespaceURI())) continue;
                            throw new DOMException(14, "An attempt was made to remove a namespace declaration when nodes exist that use it");
                        }
                    }
                } else {
                    throw new DOMException(14, "An attempt was made to remove a namespace declaration when nodes exist that use it");
                }
            }
            if (prefix != null && !prefix.equals("")) {
                element.removeAttributeNS(this.lookupNamespaceURI(prefix), localName);
            } else {
                element.removeAttribute(localName);
            }
        } else {
            throw new DOMException(9, "Only Element Nodes can have attributes");
        }
        this.fireAttributeChanged(this, attr);
    }

    public String getAttributeNameAt(int index) throws DOMException {
        if (this.m_domNode.getNodeType() == 1) {
            Element element = (Element)this.m_domNode;
            NamedNodeMap attrs = element.getAttributes();
            Node attr = attrs.item(index);
            return attr.getNodeName();
        }
        throw new DOMException(9, "Only Element Nodes can have attributes");
    }

    public String getAttributeAt(int index) throws DOMException {
        return this.getAttribute(this.getAttributeNameAt(index));
    }

    public List getAllowedElements() {
        XMLDocument rootDocument = this.getOwnerDocument();
        HashMap mappings = rootDocument.getCompletionInfoMappings();
        ElementDecl thisDecl = rootDocument.getElementDecl(this.getNodeName());
        ArrayList allowedElements = new ArrayList();
        if (thisDecl != null) {
            allowedElements.addAll(thisDecl.getChildElements(this.getNSPrefix()));
        }
        Iterator iter = mappings.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String prefix = entry.getKey().toString();
            String myprefix = this.getNSPrefix();
            if (myprefix == null) {
                myprefix = "";
            }
            if (prefix.equals(myprefix)) continue;
            CompletionInfo info = (CompletionInfo)entry.getValue();
            info.getAllElements(prefix, allowedElements);
        }
        MiscUtilities.quicksort(allowedElements, (Comparator)new ElementDecl.Compare());
        return allowedElements;
    }

    public ElementDecl getElementDecl() {
        if (this.getOwnerDocument() != null) {
            return this.getOwnerDocument().getElementDecl(this.getNodeName());
        }
        return null;
    }

    public boolean equals(Object node) {
        return node instanceof AdapterNode && ((AdapterNode)node).getNode() == this.m_domNode;
    }

    public void addAdapterNodeListener(AdapterNodeListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeAdapterNodeListener(AdapterNodeListener listener) {
        this.m_listeners.remove(this.m_listeners.indexOf(listener));
    }

    public String serializeToString() {
        XMLDocument owner = this.getOwnerDocument();
        if (owner != null) {
            return owner.serializeNodeToString(this);
        }
        if (this.m_lastRootDocument != null) {
            return this.m_lastRootDocument.serializeNodeToString(this);
        }
        String value = null;
        try {
            DOMSerializer serializer = new DOMSerializer();
            serializer.setNewLine("\n");
            value = serializer.writeToString(this.m_domNode);
        }
        catch (DOMException e) {
            Log.log(7, this, "Could not write node to string");
        }
        return value;
    }

    public String toString() {
        String s = "";
        if (this.getNodeType() == 9) {
            return "Document Root";
        }
        String nodeName = this.getNodeName();
        if (!nodeName.startsWith("#")) {
            s = s + nodeName;
        }
        if (s.equals("") && this.getNodeValue() != null) {
            String t = this.getNodeValue().trim();
            s = s + t;
        }
        return s;
    }

    Node getNode() {
        return this.m_domNode;
    }

    void removeChild(AdapterNode node) {
        if (node != null) {
            this.m_children.remove(node);
        }
    }

    void setParent(AdapterNode parent) {
        this.m_parentNode = parent;
        if (parent != null) {
            this.m_lastRootDocument = this.m_rootDocument;
            this.m_rootDocument = this.m_parentNode.getOwnerDocument();
        } else {
            this.m_lastRootDocument = this.m_rootDocument;
            this.m_rootDocument = null;
        }
    }

    private void fireNodeAdded(AdapterNode source, AdapterNode child) {
        ListIterator iterator = this.m_listeners.listIterator();
        while (iterator.hasNext()) {
            AdapterNodeListener listener = (AdapterNodeListener)iterator.next();
            listener.nodeAdded(source, child);
        }
        this.fireStructureChanged();
    }

    private void fireNodeRemoved(AdapterNode source, AdapterNode child) {
        ListIterator iterator = this.m_listeners.listIterator();
        while (iterator.hasNext()) {
            AdapterNodeListener listener = (AdapterNodeListener)iterator.next();
            listener.nodeRemoved(source, child);
        }
        this.fireStructureChanged();
    }

    private void fireLocalNameChanged(AdapterNode source) {
        ListIterator iterator = this.m_listeners.listIterator();
        while (iterator.hasNext()) {
            AdapterNodeListener listener = (AdapterNodeListener)iterator.next();
            listener.localNameChanged(source);
        }
        this.fireStructureChanged();
    }

    private void fireNamespaceChanged(AdapterNode source) {
        ListIterator iterator = this.m_listeners.listIterator();
        while (iterator.hasNext()) {
            AdapterNodeListener listener = (AdapterNodeListener)iterator.next();
            listener.namespaceChanged(source);
        }
        this.fireStructureChanged();
    }

    private void fireNodeValueChanged(AdapterNode source) {
        ListIterator iterator = this.m_listeners.listIterator();
        while (iterator.hasNext()) {
            AdapterNodeListener listener = (AdapterNodeListener)iterator.next();
            listener.nodeValueChanged(source);
        }
        this.fireStructureChanged();
    }

    private void fireAttributeChanged(AdapterNode source, String attr) {
        ListIterator iterator = this.m_listeners.listIterator();
        while (iterator.hasNext()) {
            AdapterNodeListener listener = (AdapterNodeListener)iterator.next();
            listener.attributeChanged(source, attr);
        }
        this.fireStructureChanged();
    }

    public void fireStructureChanged() {
        XMLDocument doc = this.getOwnerDocument();
        if (doc != null) {
            doc.fireStructureChanged(this);
        }
    }

    private void ensureChildrenSize(int size) {
        while (this.m_children.size() < size) {
            this.m_children.add(null);
        }
    }

    private void renameElementNode(String prefix, String localName) throws DOMException {
        Node parent = this.m_domNode.getParentNode();
        NodeList children = this.m_domNode.getChildNodes();
        Document document = this.m_domNode.getOwnerDocument();
        String qualifiedName = localName;
        if (prefix != null) {
            qualifiedName = prefix + ":" + localName;
        }
        String nsURI = this.lookupNamespaceURI(prefix);
        Element newNode = document.createElementNS(nsURI, qualifiedName);
        NamedNodeMap attrs = this.m_domNode.getAttributes();
        int attrlength = attrs.getLength();
        for (int i = 0; i < attrlength; ++i) {
            Node attr = attrs.item(i);
            newNode.setAttributeNS(attr.getNamespaceURI(), attr.getNodeName(), attr.getNodeValue());
        }
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(0);
            this.m_domNode.removeChild(child);
            newNode.appendChild(child);
        }
        parent.replaceChild(newNode, this.m_domNode);
        this.m_domNode = newNode;
    }

    private void renamePINode(String target) {
        Node parent = this.m_domNode.getParentNode();
        Document document = this.m_domNode.getOwnerDocument();
        ProcessingInstruction newNode = document.createProcessingInstruction(target, this.m_domNode.getNodeValue());
        parent.replaceChild(newNode, this.m_domNode);
        this.m_domNode = newNode;
    }

    private String lookupNamespaceURI(String prefix) {
        if ("xmlns".equals(prefix)) {
            return "http://www.w3.org/2000/xmlns/";
        }
        return ((NodeImpl)this.m_domNode).lookupNamespaceURI(prefix);
    }
}

