/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsxe.dom;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import net.sourceforge.jsxe.dom.DOMOutput;
import net.sourceforge.jsxe.dom.DOMSerializerConfiguration;
import net.sourceforge.jsxe.dom.DOMSerializerException;
import net.sourceforge.jsxe.dom.DefaultDOMLocator;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMError;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMLocator;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.w3c.dom.ls.LSSerializerFilter;

public class DOMSerializer
implements LSSerializer {
    private static final int IO_BUFFER_SIZE = 32768;
    private DOMSerializerConfiguration config;
    private LSSerializerFilter m_filter;
    private String m_newLine;

    public DOMSerializer() {
        this.config = new DOMSerializerConfiguration();
        this.m_newLine = System.getProperty("line.separator");
    }

    public DOMSerializer(DOMSerializerConfiguration config) {
        this.config = config;
        this.m_newLine = System.getProperty("line.separator");
    }

    public DOMConfiguration getDomConfig() {
        return this.config;
    }

    public LSSerializerFilter getFilter() {
        return this.m_filter;
    }

    public String getNewLine() {
        return this.m_newLine;
    }

    public void setFilter(LSSerializerFilter filter) {
        this.m_filter = filter;
    }

    public void setNewLine(String newLine) {
        this.m_newLine = newLine;
    }

    public boolean write(Node nodeArg, LSOutput destination) {
        block23: {
            if (this.m_filter == null || this.m_filter.acceptNode(nodeArg) == 1) {
                DOMErrorHandler handler;
                Object rawHandler;
                Writer writer = destination.getCharacterStream();
                String encoding = null;
                if (writer == null) {
                    OutputStream out = destination.getByteStream();
                    if (out != null) {
                        try {
                            writer = new OutputStreamWriter(out, destination.getEncoding());
                            encoding = destination.getEncoding();
                        }
                        catch (UnsupportedEncodingException uee) {
                            DefaultDOMLocator loc = new DefaultDOMLocator(nodeArg, 1, 1, 0, null);
                            try {
                                this.throwError(loc, "unsupported-encoding", (short)3, uee);
                            }
                            catch (DOMSerializerException e) {
                                // empty catch block
                            }
                            return false;
                        }
                    }
                    String id = destination.getSystemId();
                    if (id != null) {
                        try {
                            URL uri = new URL(id);
                            URLConnection con = uri.openConnection();
                            try {
                                con.setDoOutput(true);
                                con.setUseCaches(true);
                            }
                            catch (IllegalStateException ise) {
                                // empty catch block
                            }
                            con.connect();
                            writer = new OutputStreamWriter(con.getOutputStream(), destination.getEncoding());
                        }
                        catch (MalformedURLException mue) {
                            DefaultDOMLocator loc = new DefaultDOMLocator(nodeArg, 1, 1, 0, null);
                            try {
                                this.throwError(loc, "bad-uri", (short)3, mue);
                            }
                            catch (DOMSerializerException e) {
                                // empty catch block
                            }
                            return false;
                        }
                        catch (IOException ioe) {
                            DefaultDOMLocator loc = new DefaultDOMLocator(nodeArg, 1, 1, 0, null);
                            try {
                                this.throwError(loc, "io-error", (short)3, ioe);
                            }
                            catch (DOMSerializerException e) {
                                // empty catch block
                            }
                            return false;
                        }
                    }
                    DefaultDOMLocator loc = new DefaultDOMLocator(nodeArg, 1, 1, 0, null);
                    try {
                        this.throwError(loc, "no-output-specified", (short)3, null);
                    }
                    catch (DOMSerializerException e) {
                        // empty catch block
                    }
                    return false;
                }
                BufferedWriter bufWriter = new BufferedWriter(writer, 32768);
                try {
                    this.serializeNode(bufWriter, nodeArg, encoding);
                    bufWriter.close();
                    return true;
                }
                catch (IOException ioe) {
                    rawHandler = this.config.getParameter("error-handler");
                    if (rawHandler != null) {
                        handler = (DOMErrorHandler)rawHandler;
                        DefaultDOMLocator loc = new DefaultDOMLocator(nodeArg, 1, 1, 0, null);
                        DOMSerializerError error = new DOMSerializerError(loc, ioe, 3, "io-error");
                        handler.handleError(error);
                    }
                }
                catch (DOMSerializerException dse) {
                    rawHandler = this.config.getParameter("error-handler");
                    if (rawHandler == null) break block23;
                    handler = (DOMErrorHandler)rawHandler;
                    DOMError error = dse.getError();
                    handler.handleError(error);
                }
            }
        }
        return false;
    }

    public String writeToString(Node nodeArg) throws DOMException {
        StringWriter writer = new StringWriter();
        try {
            this.serializeNode(writer, nodeArg);
            writer.flush();
        }
        catch (DOMSerializerException dse) {
            throw new DOMException(11, dse.getMessage());
        }
        return writer.toString();
    }

    public boolean writeToURI(Node nodeArg, String uri) {
        return this.write(nodeArg, new DOMOutput(uri, "UTF-8"));
    }

    private void serializeNode(Writer writer, Node node) throws DOMSerializerException {
        this.serializeNode(writer, node, null);
    }

    private void serializeNode(Writer writer, Node node, String encoding) throws DOMSerializerException {
        this.rSerializeNode(writer, node, encoding, "", 1, 1, 0);
    }

    private void rSerializeNode(Writer writer, Node node, String encoding, String currentIndent, int line, int column, int offset) throws DOMSerializerException {
        boolean formatting = this.config.getFeature("format-pretty-print");
        String str = "";
        if (this.m_filter == null || this.m_filter.acceptNode(node) == 1) {
            switch (node.getNodeType()) {
                case 9: {
                    NodeList nodes;
                    if (this.config.getFeature("xml-declaration")) {
                        String header = "<?xml version=\"1.0\"";
                        String realEncoding = (String)this.config.getParameter("encoding");
                        if (realEncoding == null) {
                            realEncoding = encoding;
                        }
                        if (realEncoding != null) {
                            header = header + " encoding=\"" + realEncoding + "\"";
                        }
                        header = header + "?>";
                        this.doWrite(writer, header, node, line, column, offset);
                        offset += header.length();
                        column += header.length();
                        if (!formatting) {
                            column = 0;
                            this.doWrite(writer, this.m_newLine, node, ++line, column, offset);
                            offset += this.m_newLine.length();
                        }
                    }
                    if ((nodes = node.getChildNodes()) == null) break;
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        this.rSerializeNode(writer, nodes.item(i), encoding, currentIndent, line, column, offset);
                    }
                    break;
                }
                case 1: {
                    int i;
                    String nodeName = node.getLocalName();
                    String nodePrefix = node.getPrefix();
                    if (nodeName == null) {
                        nodeName = node.getNodeName();
                    }
                    if (formatting) {
                        column = 0;
                        str = this.m_newLine + currentIndent;
                        this.doWrite(writer, str, node, line, column, offset);
                        column += currentIndent.length();
                        offset += str.length();
                    }
                    str = this.config.getFeature("namespaces") && nodePrefix != null ? "<" + nodePrefix + ":" + nodeName : "<" + nodeName;
                    this.doWrite(writer, str, node, line, column, offset);
                    column += str.length();
                    offset += str.length();
                    NamedNodeMap attr = node.getAttributes();
                    for (int i2 = 0; i2 < attr.getLength(); ++i2) {
                        Attr currentAttr = (Attr)attr.item(i2);
                        boolean writeAttr = false;
                        if (this.config.getFeature("discard-default-content")) {
                            if (currentAttr.getSpecified()) {
                                writeAttr = true;
                            }
                        } else {
                            writeAttr = true;
                        }
                        if (!writeAttr) continue;
                        str = " " + currentAttr.getNodeName() + "=\"" + this.normalizeCharacters(currentAttr.getNodeValue()) + "\"";
                        this.doWrite(writer, str, node, line, column, offset);
                        column += str.length();
                        offset += str.length();
                    }
                    NodeList children = node.getChildNodes();
                    if (children == null) break;
                    boolean elementEmpty = false;
                    if (children.getLength() <= 0) {
                        elementEmpty = true;
                    } else if (!this.config.getFeature("element-content-whitespace")) {
                        boolean hasWSOnlyElements = true;
                        for (i = 0; i < children.getLength(); ++i) {
                            hasWSOnlyElements = hasWSOnlyElements && children.item(i).getNodeType() == 3 && children.item(i).getNodeValue().trim().equals("");
                        }
                        boolean bl = elementEmpty = formatting && hasWSOnlyElements;
                    }
                    if (!elementEmpty) {
                        str = ">";
                        this.doWrite(writer, str, node, line, column, offset);
                        column += str.length();
                        offset += str.length();
                        String indentUnit = "";
                        if (formatting) {
                            if (this.config.getFeature("soft-tabs")) {
                                Integer indentSize = (Integer)this.config.getParameter("indent");
                                if (indentSize != null) {
                                    int size = indentSize;
                                    StringBuffer buf = new StringBuffer();
                                    for (int i3 = 0; i3 < size; ++i3) {
                                        buf.append(" ");
                                    }
                                    indentUnit = buf.toString();
                                }
                            } else {
                                indentUnit = "\t";
                            }
                        }
                        for (i = 0; i < children.getLength(); ++i) {
                            this.rSerializeNode(writer, children.item(i), encoding, currentIndent + indentUnit, line, column, offset);
                        }
                        if (formatting) {
                            boolean allText = true;
                            for (int i4 = 0; i4 < children.getLength(); ++i4) {
                                if (children.item(i4).getNodeType() == 3 || children.item(i4).getNodeType() == 4) continue;
                                allText = false;
                                break;
                            }
                            if (!allText) {
                                column = 0;
                                str = this.m_newLine + currentIndent;
                                this.doWrite(writer, str, node, line, column, offset);
                                column += currentIndent.length();
                                offset += str.length();
                            }
                        }
                        str = this.config.getFeature("namespaces") && nodePrefix != null ? "</" + nodePrefix + ":" + nodeName + ">" : "</" + nodeName + ">";
                        this.doWrite(writer, str, node, line, column, offset);
                        column += str.length();
                        offset += str.length();
                        break;
                    }
                    str = "/>";
                    this.doWrite(writer, str, node, line, column, offset);
                    column += str.length();
                    offset += str.length();
                    break;
                }
                case 3: {
                    String text = node.getNodeValue();
                    if (text.equals("")) break;
                    if (formatting && text.trim().equals("")) {
                        return;
                    }
                    for (int i = 0; i < text.length(); ++i) {
                        str = text.substring(i, i + 1);
                        if (str.equals("&")) {
                            str = "&amp;";
                        }
                        if (str.equals(">")) {
                            str = "&gt;";
                        }
                        if (str.equals("<")) {
                            str = "&lt;";
                        }
                        if (str.equals("'")) {
                            str = "&apos;";
                        }
                        if (str.equals("\"")) {
                            str = "&quot;";
                        }
                        if (str.equals(this.m_newLine)) {
                            column = 0;
                            this.doWrite(writer, this.m_newLine, node, ++line, column, offset);
                            offset += this.m_newLine.length();
                            continue;
                        }
                        this.doWrite(writer, str, node, line, column, offset);
                        column += str.length();
                        offset += str.length();
                    }
                    break;
                }
                case 4: {
                    if (this.config.getFeature("cdata-sections")) {
                        str = "<![CDATA[";
                        this.doWrite(writer, str, node, line, column, offset);
                        column += str.length();
                        offset += str.length();
                        String cdata = node.getNodeValue();
                        for (int i = 0; i < cdata.length(); ++i) {
                            str = cdata.substring(i, i + 1);
                            if (str.equals("]") && i + 3 < cdata.length() && cdata.substring(i, i + 3).equals("]]>")) {
                                DefaultDOMLocator loc = new DefaultDOMLocator(node, line, column, offset, null);
                                if (this.config.getFeature("split-cdata-sections")) {
                                    i += 2;
                                    str = "]]]]>";
                                    str = str + "<![CDATA[>";
                                    this.throwError(loc, "cdata-sections-splitted", (short)1, null);
                                } else {
                                    this.throwError(loc, "invalid-data-in-cdata-section", (short)3, null);
                                }
                            }
                            if (str.equals(this.m_newLine)) {
                                column = 0;
                                this.doWrite(writer, this.m_newLine, node, ++line, column, offset);
                                offset += this.m_newLine.length();
                                continue;
                            }
                            this.doWrite(writer, str, node, line, column, offset);
                            column += str.length();
                            offset += str.length();
                        }
                        str = "]]>";
                        this.doWrite(writer, str, node, line, column, offset);
                        column += str.length();
                        offset += str.length();
                        break;
                    }
                    Text textNode = node.getOwnerDocument().createTextNode(node.getNodeValue());
                    this.rSerializeNode(writer, textNode, encoding, currentIndent, line, column, offset);
                    break;
                }
                case 8: {
                    if (!this.config.getFeature("comments")) break;
                    if (formatting) {
                        column = 0;
                        str = this.m_newLine + currentIndent;
                        this.doWrite(writer, str, node, line, column, offset);
                        column += currentIndent.length();
                        offset += str.length();
                    }
                    str = "<!--" + node.getNodeValue() + "-->";
                    this.doWrite(writer, str, node, line, column, offset);
                    column += str.length();
                    offset += str.length();
                    break;
                }
                case 7: {
                    if (formatting) {
                        column = 0;
                        str = this.m_newLine + currentIndent;
                        this.doWrite(writer, str, node, line, column, offset);
                        column += currentIndent.length();
                        offset += str.length();
                    }
                    str = "<?" + node.getNodeName() + " " + node.getNodeValue() + "?>";
                    this.doWrite(writer, str, node, line, column, offset);
                    column += str.length();
                    offset += str.length();
                    break;
                }
                case 5: {
                    str = "&" + node.getNodeName() + ";";
                    this.doWrite(writer, str, node, line, column, offset);
                    column += str.length();
                    offset += str.length();
                    break;
                }
                case 10: {
                    String internalSubset;
                    DocumentType docType = (DocumentType)node;
                    if (formatting) {
                        column = 0;
                        str = this.m_newLine + currentIndent;
                        this.doWrite(writer, str, node, line, column, offset);
                        column += currentIndent.length();
                        offset += str.length();
                    }
                    str = "<!DOCTYPE " + docType.getName();
                    this.doWrite(writer, str, node, line, column, offset);
                    column += str.length();
                    offset += str.length();
                    if (docType.getPublicId() != null) {
                        str = " PUBLIC \"" + docType.getPublicId() + "\" ";
                        this.doWrite(writer, str, node, line, column, offset);
                        column += str.length();
                        offset += str.length();
                    }
                    if (docType.getSystemId() != null) {
                        str = docType.getPublicId() == null ? " SYSTEM " : "";
                        str = str + "\"" + docType.getSystemId() + "\"";
                        this.doWrite(writer, str, node, line, column, offset);
                        column += str.length();
                        offset += str.length();
                    }
                    if ((internalSubset = docType.getInternalSubset()) != null && !internalSubset.equals("")) {
                        str = " [ " + internalSubset + " ]";
                        this.doWrite(writer, str, node, line, column, offset);
                        column += str.length();
                        offset += str.length();
                    }
                    str = ">";
                    this.doWrite(writer, str, node, line, column, offset);
                    column += str.length();
                    offset += str.length();
                    if (formatting) break;
                    column = 0;
                    str = this.m_newLine + currentIndent;
                    this.doWrite(writer, str, node, line, column, offset);
                    column += currentIndent.length();
                    offset += str.length();
                }
            }
        }
    }

    private void doWrite(Writer writer, String str, Node wnode, int line, int column, int offset) throws DOMSerializerException {
        try {
            writer.write(str, 0, str.length());
        }
        catch (IOException ioe) {
            DefaultDOMLocator loc = new DefaultDOMLocator(wnode, line, column, offset, null);
            this.throwError(loc, "io-error", (short)3, ioe);
        }
    }

    private void throwError(DOMLocator loc, String type, short severity, Exception e) throws DOMSerializerException {
        Object rawHandler = this.config.getParameter("error-handler");
        boolean handled = false;
        if (severity == 1) {
            handled = true;
        }
        DOMSerializerError error = new DOMSerializerError(loc, e, severity, type);
        if (rawHandler != null) {
            DOMErrorHandler handler = (DOMErrorHandler)rawHandler;
            handled = handler.handleError(error);
        }
        if (severity == 2 && !handled || severity == 3) {
            throw new DOMSerializerException(error);
        }
    }

    private String normalizeCharacters(String text) {
        StringBuffer newText = new StringBuffer();
        for (int i = 0; i < text.length(); ++i) {
            String str = text.substring(i, i + 1);
            if (str.equals("&")) {
                str = "&amp;";
            }
            if (str.equals(">")) {
                str = "&gt;";
            }
            if (str.equals("<")) {
                str = "&lt;";
            }
            if (str.equals("'")) {
                str = "&apos;";
            }
            if (str.equals("\"")) {
                str = "&quot;";
            }
            newText.append(str);
        }
        return newText.toString();
    }

    private static class DOMSerializerError
    implements DOMError {
        private Exception m_exception;
        private DOMLocator m_location;
        private short m_severity;
        private String m_type;

        public DOMSerializerError(DOMLocator locator, Exception e, short s, String type) {
            this.m_exception = e;
            this.m_location = locator;
            this.m_severity = s;
            this.m_type = type;
        }

        public DOMLocator getLocation() {
            return this.m_location;
        }

        public String getMessage() {
            return this.m_exception.getMessage();
        }

        public Object getRelatedData() {
            return this.m_location.getRelatedNode();
        }

        public Object getRelatedException() {
            return this.m_exception;
        }

        public short getSeverity() {
            return this.m_severity;
        }

        public String getType() {
            return this.m_type;
        }
    }
}

