/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsxe.gui;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import net.sourceforge.jsxe.JARClassLoader;
import net.sourceforge.jsxe.jsXe;
import net.sourceforge.jsxe.util.Log;
import net.sourceforge.jsxe.util.MiscUtilities;

public class Messages {
    private static Properties m_messages;
    private static Properties m_pluginMessages;
    private static Locale m_locale;
    private static boolean initialized;
    private static boolean plugins_initialized;
    static /* synthetic */ Class class$net$sourceforge$jsxe$gui$Messages;

    private static String getMessagesFileName(Locale locale) {
        StringBuffer messagesFile = new StringBuffer("messages");
        if (locale != null) {
            messagesFile.append(".").append(locale.toString());
        }
        return messagesFile.toString();
    }

    private static void loadMessages(Locale locale) {
        String messagesFile = Messages.getMessagesFileName(locale);
        try {
            Properties props = new Properties();
            FileInputStream in = new FileInputStream(jsXe.getInstallDirectory() + System.getProperty("file.separator") + "messages" + System.getProperty("file.separator") + messagesFile);
            Log.log(5, class$net$sourceforge$jsxe$gui$Messages == null ? (class$net$sourceforge$jsxe$gui$Messages = Messages.class$("net.sourceforge.jsxe.gui.Messages")) : class$net$sourceforge$jsxe$gui$Messages, "Loading message file: " + messagesFile);
            props.load(in);
            m_messages = MiscUtilities.mergeProperties(m_messages, props);
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            Log.log(9, class$net$sourceforge$jsxe$gui$Messages == null ? (class$net$sourceforge$jsxe$gui$Messages = Messages.class$("net.sourceforge.jsxe.gui.Messages")) : class$net$sourceforge$jsxe$gui$Messages, e);
        }
    }

    private static void loadPluginMessages(Locale locale) {
        String messagesFile = Messages.getMessagesFileName(locale);
        JARClassLoader loader = jsXe.getPluginLoader();
        try {
            Enumeration resources = loader.getPluginResources("messages/" + messagesFile);
            while (resources.hasMoreElements()) {
                try {
                    Properties props = new Properties();
                    URL resource = (URL)resources.nextElement();
                    Log.log(5, class$net$sourceforge$jsxe$gui$Messages == null ? Messages.class$("net.sourceforge.jsxe.gui.Messages") : class$net$sourceforge$jsxe$gui$Messages, "Loading plugin message file: " + resource.toString());
                    props.load(resource.openStream());
                    m_pluginMessages = MiscUtilities.mergeProperties(m_pluginMessages, props);
                }
                catch (FileNotFoundException e) {
                }
                catch (IOException e) {
                    Log.log(9, class$net$sourceforge$jsxe$gui$Messages == null ? Messages.class$("net.sourceforge.jsxe.gui.Messages") : class$net$sourceforge$jsxe$gui$Messages, e);
                }
            }
        }
        catch (IOException e) {
            Log.log(9, class$net$sourceforge$jsxe$gui$Messages == null ? (class$net$sourceforge$jsxe$gui$Messages = Messages.class$("net.sourceforge.jsxe.gui.Messages")) : class$net$sourceforge$jsxe$gui$Messages, e);
        }
    }

    public static void initMessages() {
        if (!initialized) {
            boolean hasVariant;
            Log.log(5, class$net$sourceforge$jsxe$gui$Messages == null ? (class$net$sourceforge$jsxe$gui$Messages = Messages.class$("net.sourceforge.jsxe.gui.Messages")) : class$net$sourceforge$jsxe$gui$Messages, "Loading localized messages: " + m_locale.toString());
            m_messages = new Properties();
            boolean hasLang = m_locale.getLanguage() != null && !m_locale.getLanguage().equals("");
            boolean hasCountry = m_locale.getCountry() != null && !m_locale.getCountry().equals("");
            boolean bl = hasVariant = m_locale.getVariant() != null && !m_locale.getVariant().equals("");
            if (hasVariant) {
                Messages.loadMessages(m_locale);
            }
            if (hasCountry) {
                Messages.loadMessages(new Locale(m_locale.getLanguage(), m_locale.getCountry()));
            }
            if (hasLang) {
                Messages.loadMessages(new Locale(m_locale.getLanguage()));
            }
            Messages.loadMessages(null);
            initialized = true;
        }
    }

    public static void initPluginMessages() {
        if (!plugins_initialized) {
            boolean hasVariant;
            m_pluginMessages = new Properties();
            Log.log(5, class$net$sourceforge$jsxe$gui$Messages == null ? (class$net$sourceforge$jsxe$gui$Messages = Messages.class$("net.sourceforge.jsxe.gui.Messages")) : class$net$sourceforge$jsxe$gui$Messages, "Loading localized messages for plugins: " + m_locale.toString());
            boolean hasLang = m_locale.getLanguage() != null && !m_locale.getLanguage().equals("");
            boolean hasCountry = m_locale.getCountry() != null && !m_locale.getCountry().equals("");
            boolean bl = hasVariant = m_locale.getVariant() != null && !m_locale.getVariant().equals("");
            if (hasVariant) {
                Messages.loadPluginMessages(m_locale);
            }
            if (hasCountry) {
                Messages.loadPluginMessages(new Locale(m_locale.getLanguage(), m_locale.getCountry()));
            }
            if (hasLang) {
                Messages.loadPluginMessages(new Locale(m_locale.getLanguage()));
            }
            Messages.loadPluginMessages(null);
            plugins_initialized = true;
        }
    }

    public Locale getLocale() {
        return m_locale;
    }

    public static void setLocale(Locale locale) {
        m_locale = locale;
        if (initialized) {
            initialized = false;
            Messages.initMessages();
            if (plugins_initialized) {
                plugins_initialized = false;
                Messages.initPluginMessages();
            }
        }
    }

    public static synchronized String getMessage(String propertyName) {
        String message = m_messages.getProperty(propertyName);
        if (message == null) {
            message = m_pluginMessages.getProperty(propertyName);
        }
        if (message == null) {
            Log.log(7, class$net$sourceforge$jsxe$gui$Messages == null ? (class$net$sourceforge$jsxe$gui$Messages = Messages.class$("net.sourceforge.jsxe.gui.Messages")) : class$net$sourceforge$jsxe$gui$Messages, "Unregistered message requested: " + propertyName);
        }
        return message;
    }

    public static synchronized String getMessage(String name, Object[] args) {
        if (name == null) {
            return null;
        }
        if (args == null) {
            return Messages.getMessage(name);
        }
        String value = Messages.getMessage(name);
        if (value == null) {
            return null;
        }
        return MessageFormat.format(value, args);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        m_locale = Locale.getDefault();
        initialized = false;
        plugins_initialized = false;
    }
}

