/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsxe.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import net.sourceforge.jsxe.ActionPlugin;
import net.sourceforge.jsxe.JARClassLoader;
import net.sourceforge.jsxe.gui.EnhancedDialog;
import net.sourceforge.jsxe.gui.Messages;
import net.sourceforge.jsxe.gui.TabbedView;
import net.sourceforge.jsxe.jsXe;

public class PluginManagerDialog
extends EnhancedDialog
implements ActionListener {
    private JButton m_ok;
    private JButton m_cancel;
    private ArrayList m_pluginNames = jsXe.getPluginLoader().getAllPluginNames();

    public PluginManagerDialog(TabbedView parent) {
        super(parent, Messages.getMessage("Plugin.Manager.Title"), true);
        this.setLocationRelativeTo(parent);
        JTable table = new JTable(new PluginManagerTableModel());
        JScrollPane tableView = new JScrollPane(table);
        final JTextArea descArea = new JTextArea();
        JScrollPane textView = new JScrollPane(descArea);
        final JSplitPane centerPane = new JSplitPane(0, true, tableView, textView);
        JPanel content = new JPanel(new BorderLayout(12, 12));
        content.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(content);
        Box buttons = new Box(0);
        buttons.add(Box.createGlue());
        this.m_ok = new JButton(Messages.getMessage("common.close"));
        this.m_ok.addActionListener(this);
        buttons.add(this.m_ok);
        buttons.add(Box.createGlue());
        ListSelectionModel model = table.getSelectionModel();
        model.setSelectionMode(0);
        model.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                DefaultListSelectionModel model = (DefaultListSelectionModel)e.getSource();
                for (int i = 0; i < PluginManagerDialog.this.m_pluginNames.size(); ++i) {
                    if (!model.isSelectedIndex(i)) continue;
                    JARClassLoader loader = jsXe.getPluginLoader();
                    String releaseDate = loader.getPluginProperty(PluginManagerDialog.this.m_pluginNames.get(i).toString(), "jsxe-plugin-release-date");
                    String author = loader.getPluginProperty(PluginManagerDialog.this.m_pluginNames.get(i).toString(), "jsxe-plugin-author");
                    String url = loader.getPluginProperty(PluginManagerDialog.this.m_pluginNames.get(i).toString(), "jsxe-plugin-url");
                    String desc = loader.getPluginProperty(PluginManagerDialog.this.m_pluginNames.get(i).toString(), "jsxe-plugin-description");
                    StringBuffer text = new StringBuffer();
                    if (author != null && !author.equals("")) {
                        text.append("Author: ");
                        text.append(author);
                        text.append("\n");
                    }
                    if (releaseDate != null && !releaseDate.equals("")) {
                        text.append("Release Date: ");
                        text.append(releaseDate);
                        text.append("\n");
                    }
                    if (url != null && !url.equals("")) {
                        text.append("URL: ");
                        text.append(url);
                        text.append("\n");
                    }
                    if (desc != null) {
                        text.append(desc);
                    }
                    descArea.setText(text.toString());
                }
            }
        });
        this.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent e) {
            }

            public void componentMoved(ComponentEvent e) {
            }

            public void componentResized(ComponentEvent e) {
            }

            public void componentShown(ComponentEvent e) {
                Container parent = PluginManagerDialog.this.getParent();
                if (parent != null) {
                    double splitLoc = 0.75;
                    centerPane.setDividerLocation(splitLoc);
                    PluginManagerDialog.this.removeComponentListener(this);
                }
            }
        });
        content.add((Component)centerPane, "Center");
        content.add((Component)buttons, "South");
        PluginManagerDialog.loadGeometry(this, "pluginmgr");
        this.setVisible(true);
    }

    public void ok() {
        this.cancel();
    }

    public void cancel() {
        PluginManagerDialog.saveGeometry(this, "pluginmgr");
        this.dispose();
    }

    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.m_ok) {
            this.ok();
        } else if (source == this.m_cancel) {
            this.cancel();
        }
    }

    private class PluginManagerTableModel
    implements TableModel {
        private PluginManagerTableModel() {
        }

        public void addTableModelListener(TableModelListener l) {
        }

        public Class getColumnClass(int columnIndex) {
            return "".getClass();
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int columnIndex) {
            Object name = null;
            switch (columnIndex) {
                case 0: {
                    return Messages.getMessage("Plugin.Manager.Name.Column.Header");
                }
                case 1: {
                    return Messages.getMessage("Plugin.Manager.Version.Column.Header");
                }
                case 2: {
                    return Messages.getMessage("Plugin.Manager.Status.Column.Header");
                }
            }
            throw new Error("Column out of range");
        }

        public int getRowCount() {
            return PluginManagerDialog.this.m_pluginNames.size();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            Object value = null;
            JARClassLoader loader = jsXe.getPluginLoader();
            switch (columnIndex) {
                case 0: {
                    return loader.getPluginProperty(PluginManagerDialog.this.m_pluginNames.get(rowIndex).toString(), "jsxe-plugin-human-readable-name");
                }
                case 1: {
                    return loader.getPluginProperty(PluginManagerDialog.this.m_pluginNames.get(rowIndex).toString(), "jsxe-plugin-version");
                }
                case 2: {
                    ActionPlugin plugin = loader.getPlugin(PluginManagerDialog.this.m_pluginNames.get(rowIndex).toString());
                    if (plugin instanceof ActionPlugin.Broken) {
                        return Messages.getMessage("Plugin.Manager.Broken.Status");
                    }
                    return Messages.getMessage("Plugin.Manager.Loaded.Status");
                }
            }
            throw new Error("Column out of range");
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public void removeTableModelListener(TableModelListener l) {
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }
    }
}

