/*
 * Decompiled with CFR 0.152.
 */
package treeview;

import java.awt.Component;
import java.util.ArrayList;
import java.util.ListIterator;
import javax.swing.JOptionPane;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import net.sourceforge.jsxe.dom.AdapterNode;
import net.sourceforge.jsxe.dom.XMLDocument;
import net.sourceforge.jsxe.jsXe;
import org.w3c.dom.DOMException;

public class DefaultViewTreeModel
implements TreeModel {
    Component view;
    private XMLDocument m_document;
    private ArrayList treeListenerList = new ArrayList();

    protected DefaultViewTreeModel(Component parent, XMLDocument doc) {
        this.m_document = doc;
        this.view = parent;
    }

    public void addTreeModelListener(TreeModelListener listener) {
        if (listener != null && !this.treeListenerList.contains(listener)) {
            this.treeListenerList.add(listener);
        }
    }

    public Object getChild(Object parent, int index) {
        AdapterNode node = (AdapterNode)parent;
        int trueIndex = this.calculateIndex(node, index);
        AdapterNode child = node.child(trueIndex);
        return child;
    }

    public int getChildCount(Object parent) {
        AdapterNode node = (AdapterNode)parent;
        int totalcount = node.childCount();
        int count = 0;
        for (int i = 0; i < totalcount; ++i) {
            AdapterNode child = node.child(i);
            if (child == null || !this.displayNode(child)) continue;
            ++count;
        }
        return count;
    }

    public int getIndexOfChild(Object parent, Object child) {
        AdapterNode node = (AdapterNode)parent;
        AdapterNode node2 = (AdapterNode)child;
        int index = this.calculateIndex(node, node2);
        return index;
    }

    public Object getRoot() {
        return this.m_document.getAdapterNode();
    }

    public boolean isLeaf(Object aNode) {
        return ((AdapterNode)aNode).childCount() <= 0;
    }

    public void removeTreeModelListener(TreeModelListener listener) {
        if (listener != null) {
            this.treeListenerList.remove(listener);
        }
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
        AdapterNode node = (AdapterNode)path.getLastPathComponent();
        String oldPrefix = node.getNSPrefix();
        String oldLocalName = node.getLocalName();
        try {
            node.setNodeName(newValue.toString());
            this.fireTreeNodesChanged(new TreeModelEvent((Object)this, path));
        }
        catch (DOMException dome) {
            JOptionPane.showMessageDialog(this.view, dome, "XML Error", 2);
        }
    }

    private int calculateIndex(AdapterNode parent, int index) {
        boolean found = false;
        int newIndex = -1;
        int nodesFound = 0;
        int size = parent.childCount();
        for (int i = 0; i < size && nodesFound <= index; ++i) {
            AdapterNode child = parent.child(i);
            if (child != null && this.displayNode(child)) {
                ++nodesFound;
            }
            ++newIndex;
        }
        return newIndex;
    }

    private int calculateIndex(AdapterNode parent, AdapterNode child) {
        int trueIndex = parent.index(child);
        if (!this.displayNode(child)) {
            trueIndex = -1;
        }
        if (trueIndex != -1) {
            int index = -1;
            for (int i = 0; i <= trueIndex; ++i) {
                AdapterNode otherChild = parent.child(i);
                if (!this.displayNode(otherChild)) continue;
                ++index;
            }
            trueIndex = index;
        }
        return trueIndex;
    }

    private boolean displayNode(AdapterNode adapter) {
        boolean showComments = jsXe.getBooleanProperty((String)"treeview.show.comment.nodes", (boolean)false);
        boolean showEmpty = jsXe.getBooleanProperty((String)"treeview.show.empty.nodes", (boolean)false);
        boolean displayNode = false;
        if (adapter != null) {
            displayNode = true;
            if (!showComments && adapter.getNodeType() == 8) {
                displayNode = false;
            }
            if (!showEmpty && adapter.getNodeType() == 3 && adapter.getNodeValue().trim().equals("")) {
                displayNode = false;
            }
        }
        return displayNode;
    }

    private void fireTreeNodesChanged(TreeModelEvent e) {
        ListIterator listeners = this.treeListenerList.listIterator();
        while (listeners.hasNext()) {
            TreeModelListener listener = (TreeModelListener)listeners.next();
            listener.treeNodesChanged(e);
        }
    }

    private void fireTreeNodesInserted(TreeModelEvent e) {
        ListIterator listeners = this.treeListenerList.listIterator();
        while (listeners.hasNext()) {
            TreeModelListener listener = (TreeModelListener)listeners.next();
            listener.treeNodesInserted(e);
        }
    }

    private void fireTreeNodesRemoved(TreeModelEvent e) {
        ListIterator listeners = this.treeListenerList.listIterator();
        while (listeners.hasNext()) {
            TreeModelListener listener = (TreeModelListener)listeners.next();
            listener.treeNodesRemoved(e);
        }
    }

    private void fireTreeStructureChanged(TreeModelEvent e) {
        ListIterator listeners = this.treeListenerList.listIterator();
        while (listeners.hasNext()) {
            TreeModelListener listener = (TreeModelListener)listeners.next();
            listener.treeStructureChanged(e);
        }
    }
}

