/*
 * Decompiled with CFR 0.152.
 */
package treeview.action;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sourceforge.jsxe.DocumentBuffer;
import net.sourceforge.jsxe.LocalizedAction;
import net.sourceforge.jsxe.gui.DocumentView;
import net.sourceforge.jsxe.gui.EnhancedDialog;
import net.sourceforge.jsxe.gui.Messages;
import net.sourceforge.jsxe.gui.TabbedView;
import net.sourceforge.jsxe.jsXe;
import treeview.DefaultView;
import treeview.TreeViewTree;

public class AddDocTypeAction
extends LocalizedAction {
    DefaultView m_defView;
    TreeViewTree m_tree;

    public AddDocTypeAction() {
        super("treeview.add.doctype.node");
    }

    public void invoke(TabbedView view, ActionEvent evt) {
        DocumentView docView = view.getDocumentView();
        if (docView instanceof DefaultView) {
            this.m_defView = (DefaultView)docView;
            this.m_tree = this.m_defView.getTree();
            EditDocTypeDialog dialog = new EditDocTypeDialog(view, null, null, null);
        }
    }

    private class EditDocTypeDialog
    extends EnhancedDialog {
        private JTextField m_nameField;
        private JTextField m_publicIDField;
        private JTextField m_systemIDField;
        private static final String m_geometryName = "treeview.editdoctypenode";

        public EditDocTypeDialog(TabbedView parent, String name, String publicId, String systemId) {
            super((Frame)parent, Messages.getMessage((String)"TreeView.EditDocType.Title"), true);
            GridBagLayout layout = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            this.getContentPane().setLayout(layout);
            int gridY = 0;
            JLabel nameLabel = new JLabel(Messages.getMessage((String)"xml.doctype.name"));
            this.m_nameField = new JTextField(name);
            JLabel publicIDLabel = new JLabel(Messages.getMessage((String)"xml.doctype.public"));
            this.m_publicIDField = new JTextField(publicId);
            JLabel systemIDLabel = new JLabel(Messages.getMessage((String)"xml.doctype.system"));
            this.m_systemIDField = new JTextField(systemId);
            constraints.gridy = gridY;
            constraints.gridx = 0;
            constraints.gridheight = 1;
            constraints.gridwidth = 1;
            constraints.weightx = 1.0;
            constraints.fill = 1;
            constraints.insets = new Insets(1, 0, 1, 0);
            layout.setConstraints(nameLabel, constraints);
            this.getContentPane().add(nameLabel);
            constraints.gridy = gridY++;
            constraints.gridx = 1;
            constraints.gridheight = 1;
            constraints.gridwidth = 1;
            constraints.weightx = 1.0;
            constraints.fill = 1;
            constraints.insets = new Insets(1, 0, 1, 0);
            layout.setConstraints(this.m_nameField, constraints);
            this.getContentPane().add(this.m_nameField);
            constraints.gridy = gridY;
            constraints.gridx = 0;
            constraints.gridheight = 1;
            constraints.gridwidth = 1;
            constraints.weightx = 1.0;
            constraints.fill = 1;
            constraints.insets = new Insets(1, 0, 1, 0);
            layout.setConstraints(publicIDLabel, constraints);
            this.getContentPane().add(publicIDLabel);
            constraints.gridy = gridY++;
            constraints.gridx = 1;
            constraints.gridheight = 1;
            constraints.gridwidth = 1;
            constraints.weightx = 1.0;
            constraints.fill = 1;
            constraints.insets = new Insets(1, 0, 1, 0);
            layout.setConstraints(this.m_publicIDField, constraints);
            this.getContentPane().add(this.m_publicIDField);
            constraints.gridy = gridY;
            constraints.gridx = 0;
            constraints.gridheight = 1;
            constraints.gridwidth = 1;
            constraints.weightx = 1.0;
            constraints.fill = 1;
            constraints.insets = new Insets(1, 0, 1, 0);
            layout.setConstraints(systemIDLabel, constraints);
            this.getContentPane().add(systemIDLabel);
            constraints.gridy = gridY++;
            constraints.gridx = 1;
            constraints.gridheight = 1;
            constraints.gridwidth = 1;
            constraints.weightx = 1.0;
            constraints.fill = 1;
            constraints.insets = new Insets(1, 0, 1, 0);
            layout.setConstraints(this.m_systemIDField, constraints);
            this.getContentPane().add(this.m_systemIDField);
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
            buttonPanel.add(Box.createGlue());
            JButton close = new JButton(Messages.getMessage((String)"common.ok"));
            close.addActionListener(new ActionListener(this){
                private final /* synthetic */ EditDocTypeDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent evt) {
                    this.this$1.ok();
                }
            });
            JButton cancel = new JButton(Messages.getMessage((String)"common.cancel"));
            cancel.addActionListener(new ActionListener(this){
                private final /* synthetic */ EditDocTypeDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent evt) {
                    this.this$1.cancel();
                }
            });
            this.getRootPane().setDefaultButton(close);
            buttonPanel.add(close);
            buttonPanel.add(Box.createGlue());
            buttonPanel.add(cancel);
            buttonPanel.add(Box.createGlue());
            constraints.gridy = gridY++;
            constraints.gridx = 0;
            constraints.gridheight = 1;
            constraints.gridwidth = 2;
            constraints.weightx = 1.0;
            constraints.fill = 1;
            constraints.insets = new Insets(1, 0, 1, 0);
            layout.setConstraints(buttonPanel, constraints);
            this.getContentPane().add(buttonPanel);
            EditDocTypeDialog.loadGeometry((Window)((Object)this), (String)m_geometryName);
            this.updateSize();
            this.show();
        }

        public String getName() {
            return this.m_nameField.getText();
        }

        public String getPublicId() {
            return this.m_publicIDField.getText();
        }

        public String getSystemId() {
            return this.m_systemIDField.getText();
        }

        public void ok() {
            String name = this.getName();
            String systemId = this.getSystemId();
            String publicId = this.getPublicId();
            if (name != null && !name.equals("") && systemId != null && !systemId.equals("")) {
                DocumentBuffer document = AddDocTypeAction.this.m_defView.getDocumentBuffer();
                try {
                    boolean found = false;
                    int i = 1;
                    while (!found) {
                        String text = document.getText(0, Math.min(100, document.getLength()) * i);
                        int end = text.indexOf("?>");
                        if (end != -1) {
                            found = true;
                            end += 2;
                            StringBuffer docType = new StringBuffer("\n<!DOCTYPE " + name);
                            if (publicId != null && !publicId.equals("")) {
                                docType.append(" PUBLIC \"" + publicId + "\"");
                            }
                            if ((publicId == null || publicId.equals("")) && systemId != null && !systemId.equals("")) {
                                docType.append(" SYSTEM");
                            }
                            if (systemId != null && !systemId.equals("")) {
                                docType.append(" \"" + systemId + "\"");
                            }
                            docType.append(">\n");
                            document.insertText(end, docType.toString());
                        }
                        ++i;
                    }
                    AddDocTypeAction.this.m_tree.updateUI();
                }
                catch (IOException ioe) {
                    jsXe.exiterror((Object)((Object)this), (Object)ioe, (int)1);
                }
            } else {
                JOptionPane.showMessageDialog((Component)((Object)this), "A Document Type Definition must have a name and SYSTEM Identifier", "Error", 2);
            }
            this.cancel();
        }

        public void cancel() {
            EditDocTypeDialog.saveGeometry((Window)((Object)this), (String)m_geometryName);
            this.dispose();
        }

        private void updateSize() {
            Dimension currentSize = this.getSize();
            Dimension requestedSize = this.getPreferredSize();
            Dimension newSize = new Dimension(Math.max(currentSize.width, requestedSize.width), Math.max(currentSize.height, requestedSize.height));
            if (newSize.width < 300) {
                newSize.width = 300;
            }
            if (newSize.height < 150) {
                newSize.height = 150;
            }
            this.setSize(newSize);
            this.validate();
        }
    }
}

