/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.logic.mail;

import java.util.List;

import org.jtp.SampleException;
import org.jtp.entity.mail.MailAddressTable;


/**
 * メールアドレステーブル情報のサービスインターフェースです。
 * 
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
public interface MailAddressTableService {
	
	/**
	 * 検索します。
	 * @return エンティティのリスト
	 * @throws SampleException システム一般例外
	 */
    public List findAll() throws SampleException;
    
	/**
	 * 登録します。
	 * @param mailAddressTable エンティティ
	 * @throws SampleException システム一般例外
	 */
    public void save(MailAddressTable mailAddressTable) throws SampleException;

	/**
	 * 更新します。
	 * @param mailAddressTable エンティティ
	 * @throws SampleException システム一般例外
	 */
    public void update(MailAddressTable mailAddressTable) throws SampleException;
    
	/**
	 * 削除します。
	 * @param mailAddressTable エンティティ
	 * @throws SampleException システム一般例外
	 */
    public void delete(MailAddressTable mailAddressTable) throws SampleException;
}
