/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.modules.apache.bsf;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Properties;
import org.apache.bsf.BSFEngine;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.bsf.util.ObjectRegistry;
import org.apache.commons.logging.Log;
import xdoclet.XDocletException;
import xdoclet.modules.apache.SubTemplateEngine;
import xdoclet.modules.apache.bsf.BsfEngineTagHandler;
import xdoclet.util.LogUtil;

public class BsfSubTemplateEngine
implements SubTemplateEngine {
    private BSFManager bsfManager;

    public BsfSubTemplateEngine() {
        Log log = LogUtil.getLog(BsfEngineTagHandler.class, (String)"ctor");
        try {
            log.debug((Object)"Creating BSFManager()");
            this.bsfManager = new BSFManager();
        }
        catch (Exception ex) {
            log.error((Object)"Exception when creating BSFManager", (Throwable)ex);
        }
    }

    public Object getVariable(String name) {
        ObjectRegistry objreg = this.bsfManager.getObjectRegistry();
        return objreg.lookup(name);
    }

    public void setVariable(String name, Object value) {
        if (value != null) {
            ObjectRegistry objreg = this.bsfManager.getObjectRegistry();
            objreg.register(name, value);
        }
    }

    public void clearVariables() {
        this.bsfManager.setObjectRegistry(new ObjectRegistry());
    }

    public String generate(String template, Properties attributes) throws XDocletException {
        Log log = LogUtil.getLog(BsfEngineTagHandler.class, (String)"generate");
        log.debug((Object)("generate() called with attributes:" + attributes));
        String scriptingEngine = attributes.getProperty("scriptengine");
        if (scriptingEngine == null) {
            throw new XDocletException("Missing attribute 'scriptengine' specifying BSF script language");
        }
        ByteArrayOutputStream bbuf = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bbuf);
        try {
            BSFEngine bsfEngine = this.bsfManager.loadScriptingEngine(scriptingEngine);
            this.bsfManager.getObjectRegistry().register("out", (Object)out);
            bsfEngine.exec("", 0, 0, (Object)template);
        }
        catch (BSFException e) {
            throw new XDocletException((Exception)((Object)e), "Exception when running scriptengine='" + scriptingEngine + "'");
        }
        out.flush();
        return bbuf.toString();
    }
}

