/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.modules.apache.struts;

import java.util.List;
import xdoclet.TemplateSubTask;
import xdoclet.XDocletException;
import xdoclet.XDocletMessages;
import xdoclet.modules.apache.struts.ActionFormTagsHandler;
import xdoclet.modules.apache.struts.ejb.XDocletModulesApacheStrutsEjbMessages;
import xdoclet.modules.ejb.XDocletModulesEjbMessages;
import xdoclet.tagshandler.PackageTagsHandler;
import xdoclet.util.Translator;
import xjavadoc.XClass;
import xjavadoc.XTag;

public class ActionFormSubTask
extends TemplateSubTask {
    protected static String DEFAULT_TEMPLATE_FILE = "resources/struts_form.xdt";
    protected String formClassPattern;
    protected XTag currentFormTag;

    public ActionFormSubTask() {
        this.setTemplateURL(((Object)((Object)this)).getClass().getResource(DEFAULT_TEMPLATE_FILE));
        this.setDestinationFile(this.getActionFormClassPattern() + ".java");
        this.addOfType("java.lang.Object");
    }

    public XTag getCurrentFormTag() {
        return this.currentFormTag;
    }

    public String getActionFormClassPattern() {
        if (this.formClassPattern != null) {
            return this.formClassPattern;
        }
        return "{0}{1}Form";
    }

    public void setCurrentFormTag(XTag t) {
        this.currentFormTag = t;
    }

    public void setPattern(String newPattern) {
        this.formClassPattern = newPattern;
    }

    public void validateOptions() throws XDocletException {
        super.validateOptions();
        if (this.getActionFormClassPattern() == null || this.getActionFormClassPattern().trim().equals("")) {
            throw new XDocletException(Translator.getString(XDocletMessages.class, (String)"PARAMETER_MISSING_OR_EMPTY", (String[])new String[]{"pattern"}));
        }
        if (this.getActionFormClassPattern().indexOf("{0}") == -1) {
            throw new XDocletException(Translator.getString(XDocletModulesEjbMessages.class, (String)"PATTERN_HAS_NO_PLACEHOLDER"));
        }
        if (this.getActionFormClassPattern().indexOf("{1}") == -1) {
            throw new XDocletException(Translator.getString(XDocletModulesEjbMessages.class, (String)"PATTERN_HAS_NO_FORM_PLACEHOLDER"));
        }
    }

    protected String getGeneratedFileName(XClass clazz) throws XDocletException {
        return PackageTagsHandler.packageNameAsPathFor((String)ActionFormTagsHandler.getActionFormClassFor(this.getCurrentClass())) + ".java";
    }

    protected boolean matchesGenerationRules(XClass clazz) throws XDocletException {
        if (!super.matchesGenerationRules(clazz)) {
            return false;
        }
        return ActionFormTagsHandler.hasFormDefinition(this.getCurrentClass());
    }

    protected void generateForClass(XClass clazz) throws XDocletException {
        List formTags = clazz.getDoc().getTags("struts.form");
        for (XTag tag : formTags) {
            this.setCurrentFormTag(tag);
            super.generateForClass(clazz);
        }
    }

    protected void engineStarted() throws XDocletException {
        System.out.println(Translator.getString(XDocletModulesApacheStrutsEjbMessages.class, (String)"GENERATING_FILE", (String[])new String[]{ActionFormTagsHandler.getActionFormClassName(this.getCurrentClass())}));
    }
}

