/*
 * Copyright (c) 2001, 2002 The XDoclet team
 * All rights reserved.
 */
package xdoclet.modules.apache.struts;


/**
 * Generates Struts Validator validation.xml deployment descriptor for struts dynamic action forms.
 *
 * @author               <a href="mailto:nick at systemmobile.com">Nick Heudecker</a>
 * @created              August 2, 2004
 * @ant.element          display-name="validation.xml" name="strutsdynaformvalidationxml"
 *      parent="xdoclet.modules.web.WebDocletTask"
 * @version              $Revision: 1.1 $
 * @xdoclet.merge-file   file="validation-global.xml" relates-to="validation.xml" description="An XML unparsed entity
 *      containing the global elements for the validation descriptor."
 * @xdoclet.merge-file   file="validation-forms.xml" relates-to="validation.xml" description="An XML unparsed entity
 *      containing form validations."
 */
public class StrutsDynaFormValidationXmlSubTask extends StrutsValidationXmlSubTask
{

    private static String DEFAULT_TEMPLATE_FILE = "resources/dynaform_validation_xml.xdt";

    /**
     * Creates a new instance of the task.
     */
    public StrutsDynaFormValidationXmlSubTask()
    {
        setTemplateURL(getClass().getResource(DEFAULT_TEMPLATE_FILE));
        setDestinationFile(GENERATED_FILE_NAME);
    }

}
