/*
 * Copyright (c) 1991-2004 Kyoto University
 * Copyright (c) 2000-2004 NAIST
 * All rights reserved
 */

/* julius.h --- top common includes */

#ifndef __JULIUS_COMMON_HEADER__
#define __JULIUS_COMMON_HEADER__

#if defined(_WIN32) && !defined(__CYGWIN32__)
/*
 *
 *  You should define -DBUILD_JULIAN to compile Julian
 *
 */
# ifdef BUILD_JULIAN
# include <config-win-julian.h>
# else
# include <config-win-julius.h>
# endif
#else
#include <config.h>
#endif

#include <define.h>
#include <sent/stddefs.h>
#include <sent/tcpip.h>
#include <sent/speech.h>
#include <sent/mfcc.h>
#include <sent/htk_param.h>
#include <sent/hmm.h>
#include <sent/gprune.h>
#include <sent/vocabulary.h>
#ifdef USE_NGRAM
#include <sent/ngram2.h>
#else /* USE_DFA */
#include <sent/dfa.h>
#endif

#ifdef USE_DFA
#include <multi-gram.h>
#endif
#include <wchmm.h>
#include <beam.h>
#include <search.h>
#include <module.h>
#include <global.h>
#include <extern.h>

#endif /* __JULIUS_COMMON_HEADER__ */
