/*
 * Copyright (c) 1991-2004 Kyoto University
 * Copyright (c) 2000-2004 NAIST
 * All rights reserved
 */

/* tcpip.h --- defines for TCP/IP commication for each server */
/* original from ~speech/src/sent/tcpip.h */

/* $Id: tcpip.h,v 1.4 2004/03/22 04:14:31 ri Exp $ */

#ifndef __SENT_SPEECH_TCPIP__
#define __SENT_SPEECH_TCPIP__

#include	<errno.h>
#if defined(_WIN32) && !defined(__CYGWIN32__)
/* win32 */
#include <winsock2.h>
#define WINSOCK
#else
/* unixen */
#include	<netdb.h>
#include	<sys/file.h>
#include	<sys/types.h>
#include	<sys/socket.h>
#include	<netinet/in.h>
#include	<sys/un.h>
#include	<fcntl.h>
#include	<arpa/inet.h>
#endif

/* default adin server port number */
#define         ADINNET_PORT 5530

/* server-client connection retry parameters */
#define		CONNECTION_RETRY_INTERVAL 2 /* sec. */
#define		CONNECTION_RETRY_TIMES    5 /* retry times */

/* net/rdwt.c */
int rd(int fd, char *data, int *len, int maxlen);
int wt(int fd, char *data, int len);
/* net/server_client.c */
int ready_as_server(int port_num);
int ready_as_server_nonblock(int port_num);
int accept_from(int sd);
int make_connection(char *hostname, int port_num);
int make_connection_unix(char *address);
int close_socket(int sd);
void cleanup_socket();

#endif /* __SENT_SPEECH_TCPIP__ */
