/*
 * Copyright (c) 1991-2004 Kyoto University
 * Copyright (c) 2000-2004 NAIST
 * All rights reserved
 */

/* adin-netaudio.c --- adin library for NetAudio interface */

/* $Id: adin_netaudio.c,v 1.5 2004/03/22 04:14:31 ri Exp $ */

/* Tested with DAT deck, DatLink hardware and NetAudio library
   on Solaris2.5.1  */

/* because of `boolean' type conflict in sentlib and datlink includes, */
/* there are only wrappers. The core functions are defined in adin_na.c */


#include <sent/stddefs.h>
#include <sent/adin.h>

/* check audio port resource and initialize */
/* will be called once at startup time */
boolean
adin_netaudio_standby(int sfreq, void *arg)
{
  char *server_devname;
  server_devname = arg;
  if (NA_standby(sfreq, server_devname) == 0) return(FALSE); /* error */
  return(TRUE);
}

/* start recording */
boolean
adin_netaudio_start()
{
  NA_start();
  j_printerr("<<< please speak >>>\n");
  return(TRUE);
}

/* stop recording */
boolean
adin_netaudio_stop()
{
  NA_stop();
  return(TRUE);
}

/* read samples from audio device */
/* try to read `sampnum' samples and returns actual sample num recorded */
int
adin_netaudio_read(SP16 *buf, int sampnum)
{
  int cnt;
  cnt = NA_read(buf, sampnum);
  if (cnt < 0) {
    j_printerr("Error: failed to read sample\n");
    return(-1);			/* return negative on error */
  }
  return(cnt);
}
