/*
 * Copyright (c) 1991-2004 Kyoto University
 * Copyright (c) 2000-2004 NAIST
 * All rights reserved
 */

/* adin_tcpip.c --- adin via TCP/IP network */

/* $Id: adin_tcpip.c,v 1.14 2004/04/27 04:53:43 ri Exp $ */

/* WARNING: currently, TCP/IP adin between different endian machines does
 not work. */

/* the sampling rate at the adinnet client should be the same as the server
   config.  They will not be checked. */

#include <sent/stddefs.h>
#include <sent/adin.h>
#include <sent/tcpip.h>

static int adinnet_sd = -1; /* listen socket for adinserv */
static int adinnet_asd = -1; /* accept socket for adinserv */
static boolean last_is_segmented = FALSE; /* FALSE if last is end of connection */

#ifdef FORK_ADINNET
static pid_t child;		/* child process ID (0 if myself is child) */
#endif

/* setup device */
boolean
adin_tcpip_standby(int freq, void *port_str)
{
  int port;

  port = atoi((char *)port_str);

  if ((adinnet_sd = ready_as_server(port)) < 0) {
    j_printerr("adin_tcpip_standby: cannot ready for server\n");
    return FALSE;
  }

  last_is_segmented = FALSE;

  return TRUE;
}

boolean
adin_tcpip_begin()
{
  if (last_is_segmented) {
    /* just wait for the next segment to be received */
  } else {
#ifdef FORK_ADINNET
    /***********************************/
    /*** server infinite loop here!! ***/
    /***********************************/
    for (;;) {
      /* wait connection */
      j_printerr("waiting connection...\n");
      adinnet_asd = accept_from(adinnet_sd);
      /* fork self */
      child = fork();
      if (child < 0) {		/* error */
	j_printerr("adin_tcpip_standby: fork failed\n");
	return FALSE;
      }
      /* child thread should handle this request */
      if (child == 0) {		/* child thread */
	break;			/* proceed */
      } else {			/* parent thread */
	j_printerr("forked process [%d] handles this request\n", child);
      }
    }
#else  /* ~FORK_ADINNET */
    j_printerr("waiting connection...\n");
    adinnet_asd = accept_from(adinnet_sd);
#endif /* FORK_ADINNET */
  }
  return TRUE;
}

/* resume recording */
boolean
adin_tcpip_end()
{
  if (!last_is_segmented) {
    /* end of connection */
    close_socket(adinnet_asd);
#ifdef FORK_ADINNET
    /* terminate this child process here */
    j_error("connection end\n");
#else
    /* wait for the next connection */
    j_printerr("connection end\n");
#endif
  } /* else, end of segment: wait for next input in current socket */
  return TRUE;
}

/* try to read `sampnum' samples and returns actual sample num recorded */
/* should not block for non-threaded input */
int
adin_tcpip_read(SP16 *buf, int sampnum)
{
  int cnt, ret;
  fd_set rfds;
  struct timeval tv;
  int status;
  
  /* check if some commands are waiting in queue */
  FD_ZERO(&rfds);
  FD_SET(adinnet_asd, &rfds);
  tv.tv_sec = 0;
  tv.tv_usec = 1;
  status = select(adinnet_asd+1, &rfds, NULL, NULL, &tv);
  if (status < 0) {		/* error */
    j_printerr("adin_tcpip_read: cannot poll\n");
    return -2;			/* error return */
  }
  if (status > 0) {		/* there are some data */
    /* read one data segment, leave rest even if any for avoid blocking */
    ret = rd(adinnet_asd, (char *)buf, &cnt, sampnum * sizeof(SP16));
    if (ret == 0) {
      /* end of segment mark */
      last_is_segmented = TRUE;
      return -1;
    }
    if (ret < 0) {
      /* end of input, mark */
      last_is_segmented = FALSE;
      return -1;
    }
  } else {			/* no data */
    cnt = 0;
  }
  cnt /= sizeof(SP16);
  return cnt;
}

/* tell the client to stop transfer */
boolean
adin_tcpip_send_pause()
{
   int count;
   char com;
   /* send stop command to adinnet client */
   com = '0';
   count = wt(adinnet_asd, &com, 1);
   if (count < 0) j_printerr("adin_tcpip_send_pause: cannot send command to client\n");
   return TRUE;
}

/* tell the client to resume transfer */
boolean
adin_tcpip_send_resume()
{
  int count;
  char com;
  /* send resume command to adinnet client */
  com = '1';
  count = wt(adinnet_asd, &com, 1);
  if (count < 0) j_printerr("adin_tcpip_send_resume: cannot send command to client\n");
  return TRUE;
}

