/*
 * Copyright (c) 1991-2004 Kyoto University
 * Copyright (c) 2000-2004 NAIST
 * All rights reserved
 */

/* wrsamp.c --- write waveform to file descpriter */

/* $Id: wrsamp.c,v 1.5 2004/03/22 04:14:31 ri Exp $ */

/* output endian is formatted to BIG ENDIAN */

#include <sent/stddefs.h>
#include <sent/speech.h>

int
wrsamp(int fd, SP16 *buf, int len)
{
  int ret;
#ifndef WORDS_BIGENDIAN
  /* swap byte order to BIG ENDIAN */
  swap_sample_bytes(buf, len);
#endif
  ret = write(fd, buf, len * sizeof(SP16));
#ifndef WORDS_BIGENDIAN
  /* undo byte swap */
  swap_sample_bytes(buf, len);
#endif
  return(ret);
}
