/*
 * Copyright (c) 1991-2004 Kyoto University
 * Copyright (c) 2000-2004 NAIST
 * All rights reserved
 */

/* dfa_malloc.c --- malloc and free DFA */

/* $Id: dfa_malloc.c,v 1.6 2004/03/22 04:14:31 ri Exp $ */

#include <sent/stddefs.h>
#include <sent/dfa.h>

/* allocate new */
DFA_INFO *
dfa_info_new()
{
  DFA_INFO *new;

  new = (DFA_INFO *)mymalloc(sizeof(DFA_INFO));
  init_dfa_cp(new);
  new->term.tw = NULL;
  new->term.term_num = new->term_num = 0;
  new->maxstatenum = 0;
  new->is_sp = NULL;
  new->sp_id = WORD_INVALID;

  return new;
}

/* free all dfa structure */
void
dfa_info_free(DFA_INFO *dfa)
{
  DFA_ARC *arc, *tmparc;
  TERM_INFO *tinfo;
  int i;

  /* free category pair info */
  free_dfa_cp(dfa);
  
  /* free terminal info */
  if (dfa->term_num != 0) {
    tinfo = &(dfa->term);
    if (tinfo->tw != NULL) {
      for(i=0;i<tinfo->term_num;i++) {
	free(tinfo->tw[i]);
      }
      free(tinfo->tw);
      free(tinfo->wnum);
    }
  }
  /* free arcs */
  if (dfa->maxstatenum > 0) {
    for(i=0;i<dfa->state_num;i++) {
      arc=dfa->st[i].arc;
      while(arc != NULL) {
	tmparc = arc->next;
	free(arc);
	arc = tmparc;
      }
    }
    /* free states */
    free(dfa->st);
  }
  if (dfa->is_sp != NULL) free(dfa->is_sp);
  /* free whole */
  free(dfa);
}
