/**
 * @file   adin_portaudio.c
 * @author Akinobu LEE
 * @date   Mon Feb 14 12:03:48 2005
 * 
 * <JA>
 * @brief  ޥ (portaudio饤֥)
 *
 * portaudioo饤֥ѤޥϤΤ٥ؿǤ
 * Ѥˤ configure  "--with-mictype=portaudio" ꤷƲ
 * Linux  Win32 ǻѲǽǤWin32⡼ɤǤϤ줬
 * ǥեȤȤʤޤ
 *
 * JuliusϥߥǥХڹԤޤϿǥХ
 * ʥޥ/饤ˤϿܥ塼ĴWindows
 * ֥ܥ塼ॳȥ  Linux  xmixer ʤɡ¾Υġ
 * ԤʤäƲ
 *
 * portaudio ϥե꡼ǥץåȥۡΥǥϥ饤֥
 * Ǥ libsent/src/adin/pa/ ˴ޤޤƤޤΥץǤ
 * simplified blocking I/O layer ѤƤޤ
 *
 * @sa http://www.portaudio.com/
 * </JA>
 * <EN>
 * @brief  Microphone input using portaudio library
 *
 * Low level I/O functions for microphone input using portaudio library.
 * To use, please specify "--with-mictype=portaudio" options
 * to configure script.  This function is currently available for Linux and
 * Win32.  On Windows, this is default.
 *
 * Julius does not alter any mixer device setting at all.  You should
 * configure the mixer for recording source (mic/line) and recording volume
 * correctly using other audio tool such as xmixer on Linux, or
 * 'Volume Control' on Windows.
 *
 * Portaudio is a free, cross platform, open-source audio I/O library.
 * The sources are included at libsent/src/adin/pa/.  This program uses
 * simplified blocking I/O layer.
 *
 * @sa http://www.portaudio.com/
 * </EN>
 *
 * $Revision:$
 * 
 */
/*
 * Copyright (c) 2004-2005 Shikano Lab., Nara Institute of Science and Technology
 * Copyright (c) 2005      Julius project team, Nagoya Institute of Technology
 * All rights reserved
 */

#include <sent/stddefs.h>

/* sound header */
#include "pa/pablio.h"

PABLIO_Stream *aStream;		///< Stream information

/** 
 * Device initialization: check device capability and open for recording.
 * 
 * @param sfreq [in] required sampling frequency.
 * @param dummy [in] a dummy data
 * 
 * @return TRUE on success, FALSE on failure.
 */
boolean
adin_mic_standby(int sfreq, void *dummy)
{
  PaError err;

  /* for safety... */
  if (sizeof(SP16) != paInt16) {
    j_error("SP16 != paInt16\n");
  }

  /* initialize device and open stream */
  err = OpenAudioStream(&aStream, sfreq, paInt16,
			(PABLIO_READ | PABLIO_MONO) );
  if (err != paNoError) {
    j_printerr("Error: %s\n", Pa_GetErrorText(err));
    return(FALSE);
  }
  return(TRUE);
}

/** 
 * Start recording.
 * 
 * @return TRUE on success, FALSE on failure.
 */
boolean
adin_mic_start()
{
  return(TRUE);
}

/** 
 * Stop recording.
 * 
 * @return TRUE on success, FALSE on failure.
 */
boolean
adin_mic_stop()
{
  return TRUE;
}

/**
 * @brief  Read samples from device
 * 
 * Try to read @a sampnum samples and returns actual number of recorded
 * samples currently available.  This function will block until
 * at least some samples are obtained.
 * 
 * @param buf [out] samples obtained in this function
 * @param sampnum [in] wanted number of samples to be read
 * 
 * @return actural number of read samples, -2 if an error occured.
 */
int
adin_mic_read(SP16 *buf, int sampnum)
{
  long avail;

  while ((avail = GetAudioStreamReadable(aStream)) <= 0) {
    Pa_Sleep(50);		/* wait for 100ms, till some input comes */
  }
  if (avail > sampnum) avail = sampnum;
  if (avail != ReadAudioStream(aStream, buf, avail)) {
    j_printerr("Error: failed to read %d samples\n", sampnum);
    return(-2);
  }
  return avail;
}

