#!/bin/sh
#
# Automatic update of binary package from Julius source archive.
# Supports 3.5 and later.
#
# !! Should be executed at "../"
#
# you should specify the target source archive .tar.gz file.
#
#

# expand archive
rm -rf julius*
tar xzvf $1
ln -s julius-* julius

# update binaries
cd julius
./support/build-all.sh
mv build-bin/* ../bin
cd ..

# copy the documents
cp -p julius/00readme* .
cp -p julius/LICENSE.txt .
cp -p julius/Release* .
cp -p julius/Sample*jconf* .
cp -p julius/gramtools/00readme.txt doc/gramtools.txt
cp -p julius/gramtools/00readme-ja.txt doc/gramtools-ja.txt

# copy manuals
find julius/ -name "*.man" -exec ./support/cpman.sh {} \;
find julius/ -name "*.man.ja" -exec ./support/cpmanja.sh {} \;
qkc -m doc/catman/*
qkc -s -m doc/catman.ja/*

# finished
echo '#### FINISHED, you should remove julius* manually ###'
