/*
 * Copyright (c) 1991-2003 Kyoto University
 * Copyright (c) 2000-2003 NAIST
 * All rights reserved
 */

/* result_tty.c --- output recognition result to stdout */

/* $Id: result_tty.c,v 1.9 2003/09/29 06:01:22 ri Exp $ */

#include <julius.h>

/* output results to stdout */

/**********************************************************************/
/************* 1st pass ***********************************************/
/**********************************************************************/

static int wst;			/* word num of last output line */
/* 1st pass: begin output */
static void
ttyout_pass1_begin()
{
  wst = 0;
}

/* 1st pass: output current result while search */
static void
ttyout_pass1_current(int t, WORD_ID *seq, int num, LOGPROB score, LOGPROB LMscore, WORD_INFO *winfo)
{
  int i,bgn;
  int len;

  /* update output line with folding */
  j_printf("\r");

  len = 0;
  if (wst == 0) {		/* first line */
    len += 11;
    j_printf("pass1_best:");
  }
  
  bgn = wst;			/* output only the last line */
  for (i=bgn;i<num;i++) {
    len += strlen(winfo->woutput[seq[i]]) + 1;
    if (len > FILLWIDTH) {	/* fold line */
      wst = i;
      j_printf("\n");
      len = 0;
    }
    j_printf(" %s",winfo->woutput[seq[i]]);
  }
  
  j_flushprint();		/* flush */
}

/* 1st pass: output final result */
static void
ttyout_pass1_final(WORD_ID *seq, int num, LOGPROB score, LOGPROB LMscore, WORD_INFO *winfo)
{
  int i,j;
  char buf[20];

  /* words */
  j_printf("\n");
  j_printf("pass1_best:");
  for (i=0;i<num;i++) {
    j_printf(" %s",winfo->woutput[seq[i]]);
  }
  j_printf("\n");

  if (verbose_flag) {		/* output further info */
    /* N-gram entries */
    j_printf("pass1_best_wordseq:");
    for (i=0;i<num;i++) {
      j_printf(" %s",winfo->wname[seq[i]]);
    }
    j_printf("\n");
    /* phoneme sequence */
    j_printf("pass1_best_phonemeseq:");
    for (i=0;i<num;i++) {
      for (j=0;j<winfo->wlen[seq[i]];j++) {
	center_name(winfo->wseq[seq[i]][j]->name, buf);
	j_printf(" %s", buf);
      }
      if (i < num-1) j_printf(" |");
    }
    j_printf("\n");
    if (debug2_flag) {
      /* logical HMMs */
      j_printf("pass1_best_HMMseq_logical:");
      for (i=0;i<num;i++) {
	for (j=0;j<winfo->wlen[seq[i]];j++) {
	  j_printf(" %s", winfo->wseq[seq[i]][j]->name);
	}
	if (i < num-1) j_printf(" |");
      }
      j_printf("\n");
    }
  }
  /* score */
  j_printf("pass1_best_score: %f", score);
#ifdef USE_NGRAM
  if (separate_score_flag) {
    j_printf(" (AM: %f  LM: %f)", score-LMscore, LMscore);
  }
#endif
  j_printf("\n");
}

/* 1st pass: end output */
static void
ttyout_pass1_end()
{
  /* no op */
  j_printf("\n");
}

/**********************************************************************/
/************* 2nd pass ***********************************************/
/**********************************************************************/
/* output word sequence of a hypothesis */
static void
put_hypo_woutput(NODE *hypo, WORD_INFO *winfo)
{
  int i,w;

  if (hypo != NULL) {
    for (i=hypo->seqnum-1;i>=0;i--) {
      w = hypo->seq[i];
      j_printf(" %s",winfo->woutput[w]);
    }
    /*    if (speech_input == SP_ADINSERV) {
      for (i=hypo->seqnum-1;i>=0;i--) {
	w = hypo->seq[i];
	if (strlen(winfo->woutput[w]) > 0)
	  wt(adinnet_asd, winfo->woutput[w], strlen(winfo->woutput[w]));
      }
      wt(adinnet_asd, (char *)&i, 0);
      }*/
  }
  j_printf("\n");  
}
/* output LM word sequence (N-gram entry/DFA category) of a hypothesis */
static void
put_hypo_wname(NODE *hypo, WORD_INFO *winfo)
{
  int i,w;

  if (hypo != NULL) {
    for (i=hypo->seqnum-1;i>=0;i--) {
      w = hypo->seq[i];
      j_printf(" %s",winfo->wname[w]);
    }
  }
  j_printf("\n");  
}
/* output phoneme sequence of a hypothesis */
static void
put_hypo_phoneme(NODE *hypo, WORD_INFO *winfo)
{
  int i,j,w;
  char buf[20];

  if (hypo != NULL) {
    for (i=hypo->seqnum-1;i>=0;i--) {
      w = hypo->seq[i];
      for (j=0;j<winfo->wlen[w];j++) {
	center_name(winfo->wseq[w][j]->name, buf);
	j_printf(" %s", buf);
      }
      if (i > 0) j_printf(" |");
    }
  }
  j_printf("\n");  
}
#ifdef CONFIDENCE_MEASURE
/* output confidence score */
#ifdef CM_MULTIPLE_ALPHA
static void
put_hypo_cmscore(NODE *hypo, int id)
{
  int i;
  int j;
  
  if (hypo != NULL) {
    for (i=hypo->seqnum-1;i>=0;i--) {
      j_printf(" %5.3f", hypo->cmscore[i][id]);
    }
  }
  j_printf("\n");  
}
#else
static void
put_hypo_cmscore(NODE *hypo)
{
  int i;
  int j;
  
  if (hypo != NULL) {
    for (i=hypo->seqnum-1;i>=0;i--) {
      j_printf(" %5.3f", hypo->cmscore[i]);
    }
  }
  j_printf("\n");
}
#endif
#endif /* CONFIDENCE_MEASURE */

/* 2nd pass output */
static void
ttyout_pass2(NODE *hypo, int rank, WORD_INFO *winfo)
{
  char ec[5] = {0x1b, '[', '1', 'm', 0};
		
  if (debug2_flag) {
    j_printf("\n%s",ec);		/* newline & bold on */
  }
  j_printf("sentence%d:",rank);
  put_hypo_woutput(hypo, winfo);
  if (verbose_flag) {
    j_printf("wseq%d:",rank);
    put_hypo_wname(hypo, winfo);
    j_printf("phseq%d:", rank);
    put_hypo_phoneme(hypo, winfo);
#ifdef CONFIDENCE_MEASURE
#ifdef CM_MULTIPLE_ALPHA
    {
      int i;
      for(i=0;i<cm_alpha_num;i++) {
	j_printf("cmscore%d[%f]:", rank, cm_alpha_bgn + i * cm_alpha_step);
	put_hypo_cmscore(hypo, i);
      }
    }
#else
    j_printf("cmscore%d:", rank);
    put_hypo_cmscore(hypo);
#endif
#endif /* CONFIDENCE_MEASURE */
  }
  if (debug2_flag) {
    ec[2] = '0';
    j_printf("%s\n",ec);		/* bold off & newline */
  }
  if (verbose_flag) {
    j_printf("score%d: %f",rank, (hypo != NULL) ? hypo->score : LOG_ZERO);
#ifdef USE_NGRAM
    if (separate_score_flag) {
      if (hypo == NULL) {
	j_printf(" (AM: %f  LM: %f)", LOG_ZERO, LOG_ZERO);
      } else {
	j_printf(" (AM: %f  LM: %f)", hypo->score - hypo->totallscore, hypo->totallscore);
      }
    }
#endif
    j_printf("\n");
  }
  j_flushprint();
}

/* 2nd pass: begin output */
static void
ttyout_pass2_begin()
{
  /* no output */
}

/* 2nd pass: end output */
static void
ttyout_pass2_end()
{
  /* no output */
}
/* 2nd pass: recognition failed output */
static void
ttyout_pass2_failed(WORD_INFO *winfo)
{
  ttyout_pass2((NODE *)NULL, 0, winfo); /* print NULL result */
}

/**********************************************************************/
/* register functions */
void
setup_result_tty()
{
  result_pass1_begin   = ttyout_pass1_begin;
  result_pass1_current = ttyout_pass1_current;
  result_pass1_final   = ttyout_pass1_final;
  result_pass1_end     = ttyout_pass1_end;
  result_pass2_begin   = ttyout_pass2_begin;
  result_pass2         = ttyout_pass2;
  result_pass2_end     = ttyout_pass2_end;
  result_pass2_failed  = ttyout_pass2_failed;
}
