/*
 * Copyright (c) 1991-2003 Kyoto University
 * Copyright (c) 2000-2003 NAIST
 * All rights reserved
 */

/* speech.h --- low-level adin */

/* $Id: speech.h,v 1.8 2003/09/29 06:01:22 ri Exp $ */

/* defines for analisys/classification server */
/* speech input limitation */
#ifndef __SENT_AZCL__
#define __SENT_AZCL__

#include <sent/adin.h>

#define MAXSEQNUM     150	/* maximum length of words per sentence hypothesis */
				/* enough? */

#define MAXSPEECHLEN  320000	/* maximum length of speech input in sample */
				/* 20 seconds in 16kHz */

#define OUTPROB_CACHE_PERIOD 100 /* period of expanding outprob cache in frame */

enum{SP_RAWFILE,SP_MIC,SP_ADINNET,SP_MFCFILE,SP_NETAUDIO,SP_STDIN}; /* speech input device*/
enum{SP_RESULT_TTY, SP_RESULT_MSOCK}; /* result output device*/

/* convert smpPeriod (ns) <-> sample frequency (Hz) */
#define period2freq(A)  (10000000.0 / (float)(A))
#define freq2period(A)  (10000000.0 / (float)(A))

/* for anlz/wrsamp.c */
int wrsamp(int fd, SP16 *buf, int len);

/* for anlz/wrwav.c */
FILE *wrwav_open(char *filename, int sfreq);
boolean wrwav_data(FILE *fp, SP16 *buf, int len);
boolean wrwav_close(FILE *fp);

/* for an;z/strip.c */
int strip_zero(SP16 a[], int len);

#endif /* __SENT_AZCL__ */
