/*
 * Copyright (c) 1991-2003 Kyoto University
 * Copyright (c) 2000-2003 NAIST
 * All rights reserved
 */

/* wrsamp.c --- write waveform to file descpriter */

/* $Id: wrsamp.c,v 1.4 2003/09/29 06:01:23 ri Exp $ */

/* output endian is formatted to BIG ENDIAN */

#include <sent/stddefs.h>
#include <sent/speech.h>

int
wrsamp(int fd, SP16 *buf, int len)
{
  int ret;
#ifndef WORDS_BIGENDIAN
  /* swap byte order to BIG ENDIAN */
  swap_sample_bytes(buf, len);
#endif
  ret = write(fd, buf, len * sizeof(SP16));
#ifndef WORDS_BIGENDIAN
  /* undo byte swap */
  swap_sample_bytes(buf, len);
#endif
  return(ret);
}
