/*
 * Copyright (c) 1991-2003 Kyoto University
 * Copyright (c) 2000-2003 NAIST
 * All rights reserved
 */

/* mkterminfo.c --- extract word index of words from DFA and WORD_INFO */
/* word IDs must be upword-sorted */

/* $Id: mkterminfo.c,v 1.5 2003/09/29 06:01:23 ri Exp $ */

#include <sent/stddefs.h>
#include <sent/dfa.h>
#include <sent/vocabulary.h>

/* construct table: terminal(category) ID -> word list */
void
make_terminfo(TERM_INFO *tinfo, DFA_INFO *dinfo, WORD_INFO *winfo)
{
  int i,w,t;
  int tnum;
  
  tnum = tinfo->term_num = dinfo->term_num;

  tinfo->wnum = (int *)mymalloc(sizeof(int) * tnum);
  for(i=0;i<tnum;i++) tinfo->wnum[i]=0;
  for(w=0;w<winfo->num;w++) {
    tinfo->wnum[winfo->wton[w]]++;
  }
  tinfo->tw = (WORD_ID **)mymalloc(sizeof(WORD_ID *) * tnum);
  for(i=0;i<tnum;i++) {
    tinfo->tw[i] = (WORD_ID *)mymalloc(sizeof(WORD_ID) * tinfo->wnum[i]);
  }
  for(i=0;i<tnum;i++) tinfo->wnum[i]=0;
  for(w=0;w<winfo->num;w++) {
    t = winfo->wton[w];
    tinfo->tw[t][tinfo->wnum[t]] = w;
    tinfo->wnum[t]++;
  }

}
  
void
terminfo_append(TERM_INFO *dst, TERM_INFO *src, int coffset, int woffset)
{
  int t, new_termnum;
  int i, j;
  WORD_ID w;

  new_termnum = coffset + src->term_num;
  if (dst->tw == NULL) {
    dst->tw = (WORD_ID **)mymalloc(sizeof(WORD_ID *) * new_termnum);
    dst->wnum = (int *)mymalloc(sizeof(int) * new_termnum);
  } else {
    dst->tw = (WORD_ID **)myrealloc(dst->tw, sizeof(WORD_ID *) * new_termnum);
    dst->wnum = (int *)myrealloc(dst->wnum, sizeof(int) * new_termnum);
  }
  for(i=0;i<src->term_num;i++) {
    t = i + coffset;
    dst->wnum[t] = src->wnum[i];
    dst->tw[t] = (WORD_ID *)mymalloc(sizeof(WORD_ID) * src->wnum[i]);
    for(j=0;j<src->wnum[i];j++) {
      dst->tw[t][j] = src->tw[i][j] + woffset;
    }
  }
  dst->term_num = new_termnum;
}
