/*
 * Copyright (c) 1991-2003 Kyoto University
 * Copyright (c) 2000-2003 NAIST
 * All rights reserved
 */

/* check_hmmtype.c --- check HMM parameter type */

/* $Id: check_hmmtype.c,v 1.4 2003/09/29 06:01:23 ri Exp $ */

#include <sent/stddefs.h>
#include <sent/htk_defs.h>
#include <sent/htk_hmm.h>
#include <sent/htk_param.h>

/* check if Julius can handle the parameter type required by HMM model */
boolean
check_hmm_options(HTK_HMM_INFO *hmm)
{
  boolean ret_flag = TRUE;
  
  if (hmm->opt.stream_info.num > 1) {
    j_printerr("ERROR: Input stream must be single\n");
    ret_flag = FALSE;
  }
  if (hmm->opt.dur_type != D_NULL) {
    j_printerr("ERROR: Duration not supported.\n");
    ret_flag = FALSE;
  }
  if (hmm->opt.cov_type != C_DIAG_C) {
    j_printerr("ERROR: Covariance matrix type must be DIAGC, others not supported.\n");
    ret_flag = FALSE;
  }

  return(ret_flag);
}

/* check if the type of input parameter matches HMM model */
boolean
check_param_coherence(HTK_HMM_INFO *hmm, HTK_Param *pinfo)
{
  boolean ret_flag;

  ret_flag = TRUE;

  /* HMM type check */
  if (hmm->opt.param_type
      != (pinfo->header.samptype & ~(F_COMPRESS | F_CHECKSUM))) {
/* 
 *     j_printerr("ERROR: incompatible parameter type\n");
 *     j_printf("HMM trained by %s\n", param_code2str(buf, hmm->opt.param_type, FALSE));
 *     j_printf("input parameter is %s\n", param_code2str(buf, pinfo->header.samptype, FALSE));
 */
    ret_flag = FALSE;
  }

  /* vector length check */
  if (hmm->opt.vec_size != pinfo->veclen) {
/* 
 *     j_printerr("ERROR: vector length differ.\n");
 *     j_printerr("HMM=%d, param=%d\n", hmm->opt.vec_size, pinfo->veclen);
 */
    ret_flag = FALSE;
  }
  
  return(ret_flag);
}

/* check only the basetype */
boolean
check_param_basetype(HTK_HMM_INFO *hmm, HTK_Param *pinfo)
{
  if ((hmm->opt.param_type & F_BASEMASK)
      != (pinfo->header.samptype & F_BASEMASK)) {
    return FALSE;
  } else {
    return TRUE;
  }
} 
