package org.junitdoc.core.rewriter;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class JDTUtils {

	public static JavaEditor getActiveJavaEditor() {
		IWorkbench workbench = PlatformUI.getWorkbench();
		IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
		IWorkbenchPage workbenchPage = workbenchWindow.getActivePage();
		if (workbenchPage == null) {
			return null;
		}

		IEditorPart editorPart = workbenchPage.getActiveEditor();

		if (editorPart instanceof JavaEditor) {
			return (JavaEditor) editorPart;
		}
		return null;
	}

	public static ICompilationUnit getICompilationUnit() {

		IWorkbench workbench = PlatformUI.getWorkbench();
		IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
		IWorkbenchPage workbenchPage = workbenchWindow.getActivePage();
		if (workbenchPage == null) {
			return null;
		}

		IEditorPart editorPart = workbenchPage.getActiveEditor();

		if (editorPart == null) {
			return null;
		}

		// IEncodingSupport encodingSupport = (IEncodingSupport) editorPart
		// .getAdapter(IEncodingSupport.class);
		// System.out.println("encoingSupport=" + encodingSupport);
		// encodingSupport.setEncoding("EUC-JP");

		IEditorInput editorInput = editorPart.getEditorInput();
		ICompilationUnit unit = (ICompilationUnit) editorInput
				.getAdapter(IJavaElement.class);

		return unit;
	}

	public static ICompilationUnit getICompilationUnit(CompilationUnit unit) {
		IResource resource = unit.getJavaElement().getResource();

		// try {
		// IResource correspondingResource = unit.getJavaElement()
		// .getCorrespondingResource();
		//
		// IResource underlyingResource = unit.getJavaElement()
		// .getUnderlyingResource();
		//
		// } catch (JavaModelException e) {
		// e.printStackTrace();
		// }

		if (resource instanceof IFile) {
			ICompilationUnit iCompilationUnit = JavaCore
					.createCompilationUnitFrom((IFile) resource);
			return iCompilationUnit;
		}
		return null;
	}
}
