package org.junitdoc.core.rewriter;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;
import org.junitdoc.JUnitDocPlugin;

public class Rewriter {

	public static void execute(ICompilationUnit unit, RewriteHandler handler) {
		execute(unit, handler, null);
	}

	public static void execute(ICompilationUnit unit, RewriteHandler handler,
			IProgressMonitor monitor) {
		execute(unit, handler, true, monitor);
	}

	public static void execute(ICompilationUnit unit, RewriteHandler handler,
			boolean forceCommit, IProgressMonitor monitor) {

		if (monitor == null) {
			monitor = new NullProgressMonitor();
		}

		try {
			final ASTParser parser = ASTParser.newParser(AST.JLS3);
			parser.setSource(unit);
			ASTNode node = parser.createAST(new SubProgressMonitor(monitor, 1));

			String source = unit.getBuffer().getContents();
			IDocument document = new Document(source);

			ASTRewrite rewrite = ASTRewrite.create(node.getAST());

			handler.rewrite(node, rewrite);

			TextEdit edit = rewrite.rewriteAST(document, unit.getJavaProject()
					.getOptions(true));

			edit.apply(document);

			String newSource = document.get();

			// update of the compilation unit
			unit.getBuffer().setContents(newSource);

			if (forceCommit) {
				// commit changes
				unit.commitWorkingCopy(false, null);
			}

		} catch (Exception e) {
			JUnitDocPlugin.errorLog(e);
		}
	}
}
