package org.junitdoc.core.rewriter;

import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.junitdoc.core.decisiontable.TestMethod;
import org.junitdoc.core.decisiontable.Type;

public class ChangeStateHandler extends RewriteHandlerAdapter {

	private Type type;

	private TestMethod testMethod;

	public ChangeStateHandler(Type type, TestMethod testMethod) {
		this.type = type;
		this.testMethod = testMethod;
	}

	public void rewrite(ASTNode node, ASTRewrite rewrite) {

		MethodDeclaration methodDeclaration = testMethod.getMethodDeclaration();

		AST ast = node.getAST();

		if (testMethod.isChecked(type)) {

			MarkerAnnotation marker = testMethod.getMarkerAnnotation(type);
			rewrite.remove(marker, null);

		} else {

			ListRewrite listRewrite = rewrite.getListRewrite(methodDeclaration,
					MethodDeclaration.MODIFIERS2_PROPERTY);

			MarkerAnnotation newAnno = ast.newMarkerAnnotation();
			newAnno.setTypeName(ast.newName(type.getFullName()));

			listRewrite.insertFirst(newAnno, null);
		}
	}
}
