package org.junitdoc.preferences;

import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.junitdoc.JUnitDocPlugin;

public class AppearancePreferencePage extends FieldEditorPreferencePage
		implements IWorkbenchPreferencePage {

	public AppearancePreferencePage() {
		super(GRID);
		setPreferenceStore(JUnitDocPlugin.getDefault().getPreferenceStore());
	}

	protected void createFieldEditors() {
		setTitle(PreferencesMessages.getString("preference.appearance"));
		Composite parent = getFieldEditorParent();

		Group decisionTableGroup = new Group(parent, SWT.NONE);
		
		decisionTableGroup.setText(PreferencesMessages
				.getString("preference.appearance.decisiontable.group"));

		StringFieldEditor decisionTableCheckLabel = new StringFieldEditor(
				PreferenceConstants.DECISION_TABLE_CHECK_LABEL,
				PreferencesMessages
						.getString("preference.appearance.decisiontable.check.label"),
				decisionTableGroup);
		addField(decisionTableCheckLabel);

		StringFieldEditor decisionTableUnCheckLabel = new StringFieldEditor(
				PreferenceConstants.DECISION_TABLE_UNCHECK_LABEL,
				PreferencesMessages
						.getString("preference.appearance.decisiontable.uncheck.label"),
				decisionTableGroup);
		addField(decisionTableUnCheckLabel);

		StringFieldEditor conditionLabel = new StringFieldEditor(
				PreferenceConstants.DECISION_TABLE_CONDITION_LABEL,
				PreferencesMessages
						.getString("preference.appearance.decisiontable.condition.label"),
				decisionTableGroup);
		addField(conditionLabel);

		StringFieldEditor actionlabel = new StringFieldEditor(
				PreferenceConstants.DECISION_TABLE_ACTION_LABEL,
				PreferencesMessages
						.getString("preference.appearance.decisiontable.action.label"),
				decisionTableGroup);
		addField(actionlabel);
	}

	public void init(IWorkbench workbench) {
	}

}
