package org.junitdoc.core.rewriter;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.junitdoc.JUnitDocPlugin;

public class ASTUtils {

	public static List<AnnotationTypeDeclaration> getAnnotationTypeDeclarationsWithAnnotation(
			ASTNode unit, final String annotation) {

		final List<AnnotationTypeDeclaration> list = new ArrayList<AnnotationTypeDeclaration>();

		unit.accept(new ASTVisitor() {

			@Override
			public boolean visit(AnnotationTypeDeclaration node) {
				List modifiers = node.modifiers();

				for (Object modifier : modifiers) {
					if (modifier instanceof MarkerAnnotation) {
						if (((MarkerAnnotation) modifier).getTypeName()
								.getFullyQualifiedName().equals(annotation)) {
							list.add(node);
						}
					}
				}
				return super.visit(node);
			}
		});
		return list;
	}

	public static List<String> findAnnotationTypeDeclarationNamesWithAnnotation(
			ASTNode unit, final String annotation) {

		final List<String> list = new ArrayList<String>();

		unit.accept(new ASTVisitor() {

			@Override
			public boolean visit(AnnotationTypeDeclaration node) {
				List modifiers = node.modifiers();

				for (Object modifier : modifiers) {
					if (modifier instanceof MarkerAnnotation) {
						if (((MarkerAnnotation) modifier).getTypeName()
								.getFullyQualifiedName().equals(annotation)) {
							list.add(node.getName().getFullyQualifiedName());
						}
					}
				}
				return super.visit(node);
			}
		});
		return list;
	}

	public static List<MarkerAnnotation> getMarkerAnnotation(ASTNode unit,
			final String annotation) {
		final List<MarkerAnnotation> list = new ArrayList<MarkerAnnotation>();

		unit.accept(new ASTVisitor() {

			@Override
			public boolean visit(MarkerAnnotation node) {
				// JUnitDocPlugin.debugLog("visit MarkerAnnotation:" + node);
				if (node.getTypeName().getFullyQualifiedName().equals(
						annotation)) {
					list.add(node);
				}

				return super.visit(node);
			}
		});
		return list;
	}

	public static List<MarkerAnnotation> getMarkers(ASTNode unit,
			final String annotation) {

		final List<MarkerAnnotation> list = new ArrayList<MarkerAnnotation>();

		unit.accept(new ASTVisitor() {

			@Override
			public boolean visit(MarkerAnnotation node) {
				// JUnitDocPlugin.debugLog("visit MarkerAnnotation:" + node);
				if (node.getTypeName().getFullyQualifiedName().equals(
						annotation)) {
					list.add(node);
				}

				return super.visit(node);
			}
		});
		return list;
	}

	public static MethodDeclaration findMethodDeclaration(ASTNode unit,
			final IMethod method) {

		final MethodDeclaration[] rtn = new MethodDeclaration[1];

		unit.accept(new ASTVisitor() {

			@Override
			public boolean visit(MethodDeclaration node) {
				String methodName = node.getName().getFullyQualifiedName();
				if (methodName.equals(method.getElementName())) {

					try {
						if (node.getStartPosition() == method.getSourceRange()
								.getOffset()) {
							rtn[0] = node;
							return false;
						}
					} catch (JavaModelException e) {
						JUnitDocPlugin.errorLog(e);
					}
				}
				return super.visit(node);
			}
		});
		return rtn[0];
	}

	public static List<MethodDeclaration> findMethodDeclarations(ASTNode unit) {

		final List<MethodDeclaration> list = new ArrayList<MethodDeclaration>();

		unit.accept(new ASTVisitor() {

			@Override
			public boolean visit(MethodDeclaration node) {
				list.add(node);
				return super.visit(node);
			}
		});

		return list;
	}

	public static List<MethodDeclaration> findAnnotatedMethodDeclarations(
			ASTNode unit, final String annotation) {

		final List<MethodDeclaration> list = new ArrayList<MethodDeclaration>();

		unit.accept(new ASTVisitor() {

			@Override
			public boolean visit(MethodDeclaration node) {
				List modifiers = node.modifiers();

				for (Object modifier : modifiers) {
					if (modifier instanceof MarkerAnnotation) {
						if (((MarkerAnnotation) modifier).getTypeName()
								.getFullyQualifiedName().equals(annotation)) {
							list.add(node);
						}
					}
				}
				return super.visit(node);
			}
		});

		return list;
	}

	public static boolean isConditionOrActionAnnotation(
			String testTargetMethod, MarkerAnnotation anno) {

		String name = anno.getTypeName().getFullyQualifiedName();

		return name.startsWith(testTargetMethod);
		// + "." + Const.CONDITION_TAG)
		// || name.startsWith(testTargetMethod + "." + Const.ACTION_TAG);
	}

	public static boolean isAnnotated(BodyDeclaration declaration,
			String annotationName) {

		List modifiers = declaration.modifiers();

		for (Object modifier : modifiers) {
			if (modifier instanceof MarkerAnnotation) {
				MarkerAnnotation anno = (MarkerAnnotation) modifier;

				if (anno.getTypeName().getFullyQualifiedName().equals(
						annotationName)) {
					return true;
				}
			}
		}
		return false;
	}

	public static CompilationUnit createAST(ICompilationUnit unit) {
		ASTParser parser = createASTParser();
		parser.setSource(unit);
		return (CompilationUnit) parser.createAST(new NullProgressMonitor());
	}

	public static CompilationUnit createAST(char[] sourceCharArray) {
		ASTParser parser = createASTParser();
		parser.setSource(sourceCharArray);
		CompilationUnit unit = (CompilationUnit) parser
				.createAST(new NullProgressMonitor());
		return unit;
	}

	private static ASTParser createASTParser() {
		ASTParser parser = ASTParser.newParser(AST.JLS3);
		// parser.setResolveBindings(true);
		return parser;
	}

	public static TypeDeclaration getFirstTypeDeclaration(ASTNode node) {

		final TypeDeclaration[] rtn = new TypeDeclaration[1];

		node.accept(new ASTVisitor() {
			@Override
			public boolean visit(TypeDeclaration node) {
				rtn[0] = node;
				return false;
			}
		});
		return rtn[0];
	}

	public static AnnotationTypeDeclaration findAnnotationTypeDeclaration(
			ASTNode node, final String target) {

		final AnnotationTypeDeclaration[] rtn = new AnnotationTypeDeclaration[1];

		node.accept(new ASTVisitor() {
			@Override
			public boolean visit(AnnotationTypeDeclaration node) {
				if (node.getName().getFullyQualifiedName().equals(target)) {
					rtn[0] = node;
					return false;
				}
				return true;
			}
		});
		return rtn[0];
	}

	public static List<MarkerAnnotation> findAnnotatedMarkerAnnotation(
			BodyDeclaration declaration) {
		final List<MarkerAnnotation> list = new ArrayList<MarkerAnnotation>();

		List modifiers = declaration.modifiers();

		for (Object modifier : modifiers) {
			if (modifier instanceof MarkerAnnotation) {
				MarkerAnnotation anno = (MarkerAnnotation) modifier;
				list.add(anno);
			}
		}
		return list;
	}
}
