package org.junitdoc.core.rewriter;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;

public class IncludeMethodHandler extends RewriteHandlerAdapter {

	private String decisionTableName;

	private MethodDeclaration methodDeclaration;

	private MarkerAnnotation newAnnotation;

	private IMethod method;

	public IncludeMethodHandler(String decisionTableName, IMethod testMethod) {
		this.decisionTableName = decisionTableName;
		this.method = testMethod;
		findTestMethods(testMethod);
	}

	private void findTestMethods(IMethod testMethod) {
		ICompilationUnit source = testMethod.getCompilationUnit();
		CompilationUnit ast = ASTUtils.createAST(source);

		methodDeclaration = ASTUtils.findMethodDeclaration(ast, testMethod);
	}

	@Override
	public boolean confirmRewrite() {
		if (methodDeclaration == null) {
			return false;
		}
		if (ASTUtils.isAnnotated(methodDeclaration, decisionTableName)) {
			return false;
		}

		return true;
	}

	public void rewrite(ASTNode node, ASTRewrite rewrite) {

		AST ast = node.getAST();

		ListRewrite listRewrite = rewrite.getListRewrite(methodDeclaration,
				MethodDeclaration.MODIFIERS2_PROPERTY);

		newAnnotation = ast.newMarkerAnnotation();
		newAnnotation.setTypeName(ast.newName(decisionTableName));

		listRewrite.insertFirst(newAnnotation, null);

	}

	@Override
	public void afterRewrite(ICompilationUnit source) {
		JDTUtils.getActiveJavaEditor().setSelection(method);
	}
}
