package org.junitdoc.preferences;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.junitdoc.JUnitDocPlugin;

public class TemplatePreferencePage extends PreferencePage implements
		IWorkbenchPreferencePage {

	private static final String DECISIONTABLE_DIALOG_TITLE = "preference.template.dialog.title";
	private static final String DECISIONTABLE_LABEL = "preference.template.decisiontable.label";
	private static final String BUTTON_LABEL = "preference.template.button.label";

	private String templateText;

	protected Control createContents(Composite parent) {
		IPreferenceStore store = JUnitDocPlugin.getDefault()
				.getPreferenceStore();
		templateText = store.getString(PreferenceConstants.DECISION_TABLE_TEMPLATE);

		Composite composite = new Composite(parent, SWT.NULL);

		GridLayout layout = new GridLayout(2, false);
		composite.setLayout(layout);

		Label label = new Label(composite, SWT.NONE);
		label.setText(PreferencesMessages.getString(DECISIONTABLE_LABEL));

		Button button = new Button(composite, SWT.PUSH);
		button.setText(PreferencesMessages.getString(BUTTON_LABEL));
		button.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent evt) {
				TemplateDialog dialog = new TemplateDialog(getShell());
				if (dialog.open() == Dialog.OK) {
					;
				}
			}
		});

		return composite;
	}

	public boolean performOk() {
		IPreferenceStore store = JUnitDocPlugin.getDefault()
				.getPreferenceStore();
		store.setValue(PreferenceConstants.DECISION_TABLE_TEMPLATE, templateText);
		return true;
	}

	protected void performDefaults() {
		IPreferenceStore store = JUnitDocPlugin.getDefault()
				.getPreferenceStore();
		templateText = store.getDefaultString(PreferenceConstants.DECISION_TABLE_TEMPLATE);
	}

	public void init(IWorkbench workbench) {
	}

	/**
	 * The dialog to edit template.
	 */
	private class TemplateDialog extends Dialog {

		private Text template;

		public TemplateDialog(Shell parentShell) {
			super(parentShell);
			setShellStyle(getShellStyle() | SWT.RESIZE);
		}

		public String getTemplate() {
			return template.getText();
		}

		protected Point getInitialSize() {
			return new Point(400, 350);
		}

		protected void createButtonsForButtonBar(Composite parent) {
			super.createButtonsForButtonBar(parent);
			updateButtonStatus();
		}

		protected Control createDialogArea(Composite parent) {
			getShell().setText(PreferencesMessages.getString(DECISIONTABLE_DIALOG_TITLE));

			Composite composite = new Composite(parent, SWT.NULL);
			composite.setLayout(new GridLayout(1, false));
			composite.setLayoutData(new GridData(GridData.FILL_BOTH));

			Label label = new Label(composite, SWT.NONE);
			label.setText(PreferencesMessages.getString(DECISIONTABLE_LABEL));

			template = new Text(composite, SWT.BORDER | SWT.MULTI
					| SWT.V_SCROLL | SWT.H_SCROLL);
			template.setLayoutData(new GridData(GridData.FILL_BOTH));
			template.setText(templateText);

			template.addModifyListener(new ModifyListener() {
				public void modifyText(ModifyEvent e) {
					updateButtonStatus();
				}
			});

			return composite;
		}

		protected void okPressed() {
			templateText = template.getText();
			super.okPressed();
		}

		private void updateButtonStatus() {
			getButton(IDialogConstants.OK_ID).setEnabled(
					template.getText().length() > 0);
		}
	}
}