package org.junitdoc.ui.events;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class TreeMouseEvent {

	private MouseEvent mouseEvent;
	private int columnIndex;
	private TreeItem treeItem;
	private TreeColumn treeColumn;

	TreeMouseEvent(MouseEvent mouseEvent, TreeItem treeItem,
			TreeColumn selectedColumn, int columnIndex) {
		this.mouseEvent = mouseEvent;
		this.treeItem = treeItem;
		this.treeColumn = selectedColumn;
		this.columnIndex = columnIndex;
	}

	public int getSelectedColumnIndex() {
		return columnIndex;
	}

	public TreeItem getSelectedTreeItem() {
		return treeItem;
	}

	public MouseEvent getOriginalMouseEvent() {
		return mouseEvent;
	}

	public TreeColumn getSelectedTreeColumn() {
		return treeColumn;
	}
}