package org.junitdoc.core.util;

import java.util.HashSet;
import java.util.Set;

public class JavaNameChecker {

	private static Set<String> keywords = new HashSet<String>();

	static {
		String[] kws = { "abstract", "continue", "for", "new", "switch",
				"assert", "default", "if", "package", "synchronized",
				"boolean", "do", "goto", "private", "this", "break", "double",
				"implements", "protected", "throw", "byte", "else", "import",
				"public", "throws", "case", "enum", "instanceof", "return",
				"transient", "catch", "extends", "int", "short", "try", "char",
				"final", "interface", "static", "void", "class", "finally",
				"long", "strictfp", "volatile", "const", "float", "native",
				"super", "while",
				// literals
				"null", "true", "false" };

		for (int i = 0; i < kws.length; i++)
			keywords.add(kws[i]);
	}

	public static boolean isJavaIdentifier(String value) {
		// check 1 keyword
		if (keywords.contains(value)) {
			return true;
		}

		// check 2 start character
		if (!Character.isJavaIdentifierStart(value.charAt(0))) {
			return true;
		}

		// check 3 other character
		for (int index = 0; index < value.length(); index++) {
			if (!Character.isJavaIdentifierPart(value.charAt(index))) {
				return true;
			}
		}
		return false;
	}
}
