package sample;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.junitdoc.core.rewriter.ASTUtils;
import org.junitdoc.ui.decisiontable.DecisionTablesTabPage;

public class JFaceMain extends ApplicationWindow {
	public JFaceMain() {
		super(null);
	}

	public static void main(String[] args) {
		JFaceMain window = new JFaceMain();
		window.setBlockOnOpen(true);
		window.open();
		Display.getCurrent().dispose();
	}

	protected Control createContents(Composite parent) {
		Composite container = new Composite(parent, SWT.NONE);
		container.setLayout(new GridLayout(1, true));

		// DecisionTableViewer viewer = new DecisionTableViewer(container,
		// "plusFunction");

		try {

			CompilationUnit unit = ASTUtils
					.createAST(parseJavaSource("src/main/java/sample/SampleTest.java"));

			DecisionTablesTabPage page = new DecisionTablesTabPage(container);
			page.initialize(unit);
			
		} catch (Exception e) {
			e.printStackTrace();
		}

		return container;
	}

	private static char[] parseJavaSource(String path) throws IOException {
		FileReader reader = new FileReader(path);
		BufferedReader br = new BufferedReader(reader);

		StringBuilder sb = new StringBuilder();

		String line;
		while ((line = br.readLine()) != null) {
			// System.out.println(line);
			sb.append(line);
		}
		br.close();

		char[] source = sb.toString().toCharArray();

		return source;

	}
}