package org.junitdoc.ui.decisiontable;

import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;

import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.eclipse.swt.widgets.Shell;
import org.junitdoc.JUnitDocPlugin;
import org.junitdoc.core.decisiontable.DecisionTableModel;
import org.junitdoc.preferences.PreferenceConstants;
import org.junitdoc.ui.Exporter;

public class HtmlExporter extends Exporter {

	private DecisionTableModel[] decisionTableModels;

	private boolean isMultiExport = false;

	public HtmlExporter(Shell shell, String title,
			DecisionTableModel[] decisionTableModels) {
		super(shell, title);
		this.decisionTableModels = decisionTableModels;
	}

	public HtmlExporter(Shell shell, String title,
			DecisionTableModel[] decisionTableModels, boolean isMultiExport) {
		this(shell, title, decisionTableModels);
		this.isMultiExport = isMultiExport;
	}

	@SuppressWarnings("deprecation")
	@Override
	protected String getContents() throws Exception {

		Velocity.setProperty("resource.loader", "class");
		Velocity
				.setProperty("class.resource.loader.class",
						"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");

		Velocity.init();
		VelocityContext context = new VelocityContext();
		context.put("charset", "UTF-8");
		context.put("tables", decisionTableModels);

		StringWriter sw = new StringWriter();

		Velocity.evaluate(context, sw, null, JUnitDocPlugin.getDefault()
				.getPreferenceStore().getString(
						PreferenceConstants.DECISION_TABLE_TEMPLATE));

		sw.flush();

		return sw.toString();
	}

	@Override
	protected String[] getFilterExtensions() {
		return new String[] { "*.html" };
	}

	@Override
	protected String getFileName() {
		if (decisionTableModels == null || decisionTableModels.length == 0) {
			return "";
		}

		if (isMultiExport) {
			SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
			String now = format.format(Calendar.getInstance().getTime());

			return "decisionTables-" + now + ".html";
		}

		String fileName = decisionTableModels[0].getTestClassName();
		return fileName.substring(0, fileName.lastIndexOf('.')) + ".html";
	}
}
