/*
 * Decompiled with CFR 0.152.
 */
package junkutil.gui;

import java.awt.Component;
import java.awt.Font;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class LzLookAndFeel {
    public static final String CLASSNAME_METAL = "javax.swing.plaf.metal.MetalLookAndFeel";
    public static final String CLASSNAME_MOTIF = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
    public static final String CLASSNAME_WINDOWS = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";

    private LzLookAndFeel() {
    }

    public static boolean toSystem() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean toCrossPlatform() {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean toMetal() {
        try {
            UIManager.setLookAndFeel(CLASSNAME_METAL);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean toMotif() {
        try {
            UIManager.setLookAndFeel(CLASSNAME_MOTIF);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean toWindows() {
        try {
            UIManager.setLookAndFeel(CLASSNAME_WINDOWS);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void update(Component c) {
        if (c == null) {
            return;
        }
        SwingUtilities.updateComponentTreeUI(c);
    }

    public static boolean isAvailableSystem() {
        return LzLookAndFeel.isAvailableLookAndFeel(UIManager.getSystemLookAndFeelClassName());
    }

    public static boolean isAvailableCrossPlatform() {
        return LzLookAndFeel.isAvailableLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
    }

    public static boolean isAvailableMetal() {
        return LzLookAndFeel.isAvailableLookAndFeel(CLASSNAME_METAL);
    }

    public static boolean isAvailableMotif() {
        return LzLookAndFeel.isAvailableLookAndFeel(CLASSNAME_MOTIF);
    }

    public static boolean isAvailableWindows() {
        return LzLookAndFeel.isAvailableLookAndFeel(CLASSNAME_WINDOWS);
    }

    public static boolean isAvailableLookAndFeel(String lafName) {
        try {
            Class<?> lnfClass = Class.forName(lafName);
            LookAndFeel laf = (LookAndFeel)lnfClass.newInstance();
            return laf.isSupportedLookAndFeel();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void setFont(Font font) {
        UIManager.put("Label.font", font);
        UIManager.put("Menu.font", font);
        UIManager.put("MenuItem.font", font);
        UIManager.put("Button.font", font);
        UIManager.put("ComboBox.font", font);
        UIManager.put("MenuBar.font", font);
        UIManager.put("PopupMenu.font", font);
        UIManager.put("RadioButton.font", font);
        UIManager.put("CheckBox.font", font);
        UIManager.put("List.font", font);
        UIManager.put("TextComponent.font", font);
        UIManager.put("TextField.font", font);
        UIManager.put("TextArea.font", font);
        UIManager.put("TextPane.font", font);
        UIManager.put("EditorPane.font", font);
        UIManager.put("Tree.font", font);
        UIManager.put("ToolBar.font", font);
        UIManager.put("ToolTip.font", font);
        UIManager.put("ViewPort.font", font);
        UIManager.put("PasswordField.font", font);
        UIManager.put("Table.font", font);
    }
}

