/*
 * Decompiled with CFR 0.152.
 */
package junkutil.set;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import junkutil.common.StringUtil;
import junkutil.set.LzList;

public class LzMap {
    private Map base;

    public LzMap() {
        this.base = new HashMap();
    }

    public LzMap(Map map) {
        this.base = map;
    }

    public LzMap(Object[] keyValues) {
        if (keyValues.length % 2 != 0) {
            throw new IllegalArgumentException();
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (int i = 0; i < keyValues.length; i += 2) {
            map.put(keyValues[i], keyValues[i + 1]);
        }
        this.base = map;
    }

    public LzMap(List keyValues) {
        if (keyValues.size() % 2 != 0) {
            throw new IllegalArgumentException();
        }
        HashMap map = new HashMap();
        for (int i = 0; i < keyValues.size(); i += 2) {
            map.put(keyValues.get(i), keyValues.get(i + 1));
        }
        this.base = map;
    }

    public LzMap(Object[] keys, Object[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException();
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        this.base = map;
    }

    public LzMap(List keys, List values) {
        if (keys.size() != values.size()) {
            throw new IllegalArgumentException();
        }
        HashMap map = new HashMap();
        for (int i = 0; i < keys.size(); ++i) {
            map.put(keys.get(i), values.get(i));
        }
        this.base = map;
    }

    public LzMap(Properties prop) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String string : prop.keySet()) {
            map.put(string, prop.getProperty(string));
        }
        this.base = map;
    }

    public List keys() {
        return LzMap.map2keys(this.base);
    }

    public List sortedKeys() {
        return new LzList(LzMap.map2keys(this.base)).sortAsc().list();
    }

    public static List map2keys(Map arg) {
        return Arrays.asList(arg.keySet().toArray());
    }

    public List values() {
        return LzMap.map2values(this.base);
    }

    public static List map2values(Map arg) {
        return Arrays.asList(arg.values().toArray());
    }

    public Map map() {
        return this.base;
    }

    public LzMap orLeft(Map arg) {
        HashMap map = new HashMap(this.base);
        for (Object key : arg.keySet()) {
            if (map.containsKey(key)) continue;
            map.put(key, arg.get(key));
        }
        return new LzMap(map);
    }

    public LzMap marge(Map arg) {
        return this.orRight(arg);
    }

    public LzMap orRight(Map arg) {
        HashMap map = new HashMap(this.base);
        for (Object key : arg.keySet()) {
            map.put(key, arg.get(key));
        }
        return new LzMap(map);
    }

    public LzMap andLeft(Map arg) {
        HashMap map = new HashMap();
        List mapKeys = LzMap.map2keys(this.base);
        List argKeys = LzMap.map2keys(arg);
        List andKeys = new LzList(mapKeys).and(argKeys).list();
        for (Object key : andKeys) {
            Object obj1 = this.base.get(key);
            Object obj2 = arg.get(key);
            if (obj1 != null) {
                map.put(key, obj1);
                continue;
            }
            map.put(key, obj2);
        }
        return new LzMap(map);
    }

    public LzMap andRight(Map arg) {
        HashMap map = new HashMap();
        List mapKeys = LzMap.map2keys(this.base);
        List argKeys = LzMap.map2keys(arg);
        List andKeys = new LzList(mapKeys).and(argKeys).list();
        for (Object key : andKeys) {
            Object obj1 = this.base.get(key);
            Object obj2 = arg.get(key);
            if (obj2 != null) {
                map.put(key, obj2);
                continue;
            }
            map.put(key, obj1);
        }
        return new LzMap(map);
    }

    public LzMap set(Map arg) {
        HashMap map = new HashMap(this.base);
        for (Object key : map.keySet()) {
            if (!arg.containsKey(key)) continue;
            map.put(key, arg.get(key));
        }
        return new LzMap(map);
    }

    public boolean equals(Map arg) {
        if (this.base.keySet().size() != arg.keySet().size()) {
            return false;
        }
        if (!new LzList(LzMap.map2keys(this.base)).equalsOnSort(LzMap.map2keys(arg))) {
            return false;
        }
        for (Object key : this.base.keySet()) {
            Object obj2;
            Object obj1 = this.base.get(key);
            if (obj1.equals(obj2 = arg.get(key))) continue;
            return false;
        }
        return true;
    }

    public LzMap subset(Object[] keys) {
        return this.subset(Arrays.asList(keys));
    }

    public LzMap subset(List keys) {
        HashMap map = new HashMap();
        for (int i = 0; i < keys.size(); ++i) {
            Object key = keys.get(i);
            if (key == null) continue;
            map.put(key, this.base.get(key));
        }
        return new LzMap(map);
    }

    public LzMap keyGrep(String re) {
        HashMap map = new HashMap();
        Pattern pattern = Pattern.compile(re);
        List keys = this.keys();
        for (Object key : keys) {
            if (!StringUtil.match(key.toString(), pattern)) continue;
            map.put(key, this.base.get(key));
        }
        return new LzMap(map);
    }

    public LzMap keyUngrep(String keyEx) {
        HashMap map = new HashMap();
        Pattern pattern = Pattern.compile(keyEx);
        List keys = this.keys();
        for (Object key : keys) {
            if (StringUtil.match(key.toString(), pattern)) continue;
            map.put(key, this.base.get(key));
        }
        return new LzMap(map);
    }

    public boolean equals(String arg) {
        return this.toString().equals(arg);
    }

    public String toString() {
        List keys = this.sortedKeys();
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        for (int i = 0; i < keys.size(); ++i) {
            Object key = keys.get(i);
            Object value = this.base.get(key);
            if (i != 0) {
                sb.append(" ");
            }
            sb.append(key.toString());
            sb.append("=");
            if (value != null) {
                sb.append(value.toString());
            } else {
                sb.append("null");
            }
            if (i == keys.size() - 1) continue;
            sb.append(",");
        }
        sb.append("}");
        return new String(sb);
    }
}

