/*
 * Decompiled with CFR 0.152.
 */
package junkutil.text;

import java.util.HashMap;
import java.util.regex.Matcher;
import junkutil.common.StringUtil;
import junkutil.text.RegExpCallback;
import junkutil.text.RegExpUtil;

public class LzTemplate {
    public static void main(String[] args) {
        RegExpUtil re = new RegExpUtil();
        String test1 = "aaa${foo}bbb${bar:escHtml}ccc${hoge:trim:escHtml}ddd";
        String test2 = "aaa${}bbb${ccc$}ddd";
        String placeHolderRE = "\\$\\{([^{}:\\$]+)(?:[:]([^{}\\$]+))?\\}";
        test1.replaceAll("", "");
        TemplateCallback callback = new TemplateCallback();
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("foo", "\u3075\u3049");
        values.put("bar", "\u3070\u3041");
        values.put("hoge", "\u307b\u3052");
        callback.setValues(values);
        System.out.println(re.replaceBack(test1, placeHolderRE, callback));
        System.out.println(re.replaceBack(test2, placeHolderRE, callback));
    }

    public static class TemplateCallback
    implements RegExpCallback {
        private HashMap values;

        @Override
        public String getReplaced(StringBuffer buff, Matcher matcher) {
            if (matcher.groupCount() < 2) {
                throw new IllegalArgumentException("matcher.groupCount() is " + matcher.groupCount());
            }
            String valueName = matcher.group(1);
            Object valueObj = this.values.get(valueName);
            String valueStr = valueObj != null ? valueObj.toString() : valueName;
            String filterNames = matcher.group(2) != null ? "." + matcher.group(2) : "";
            String[] filters = filterNames.split(":");
            String filterStr = StringUtil.join(filters, "-");
            return "[" + valueStr + filterStr + "]";
        }

        public HashMap getValues() {
            return this.values;
        }

        public void setValues(HashMap values) {
            this.values = values;
        }
    }
}

