package junkutil.common;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;

/**
 * t@C
 * @author Hiroyuki Shiota
 */
public class FileUtil {
	/**
	 * VXẻsR[h
	 */
	private static final String ln = System.getProperty(SystemKey.LINE_SEPARATOR);
	
	/**
	 * vCx[gRXgN^
	 */
	private FileUtil() {
	}
	
	/**
	 * ݂mF
	 * @param filename
	 * @return
	 */
	public static boolean exists(String filename) {
		return new File(filename).exists();
	}
	
	/**
	 * eLXgǂݍ
	 * @param filename - t@C
	 * @return eLXg
	 * @throws IOException
	 */
	public static String readFile(String filename) throws IOException {
		return readFile(filename, null);
	}
	
	/**
	 * eLXgǂݍ
	 * @param filename - t@C
	 * @param encoding - GR[fBO
	 * @return eLXg
	 * @throws IOException
	 */
	public static String readFile(String filename, String encoding) throws IOException {
		BufferedReader br = null;
		StringBuffer result = null;
		try {
			if (encoding != null) {
				br = new BufferedReader(new InputStreamReader(new FileInputStream(filename), encoding));
			} else {
				br = new BufferedReader(new InputStreamReader(new FileInputStream(filename)));
			}
			String line;
			result = new StringBuffer();
			while ((line = br.readLine()) != null) {
				result.append(line);
				result.append(ln);
			}
		} finally {
			try { br.close(); } catch (Exception ee) {}
		}
		return new String(result);
	}
	
	/**
	 * Ssǂݍ
	 * @param filename - t@C
	 * @return Xg
	 * @throws IOException
	 */
	public static List readLines(String filename) throws IOException {
		return readLines(filename, null);
	}
	
	/**
	 * Ssǂݍ
	 * @param filename - t@C
	 * @return Xg
	 * @throws IOException
	 */
	public static List readLines(String filename, String encoding) throws IOException {
		BufferedReader br = null;
		ArrayList result = null;
		try {
			if (encoding != null) {
				br = new BufferedReader(new InputStreamReader(new FileInputStream(filename), encoding));
			} else {
				br = new BufferedReader(new InputStreamReader(new FileInputStream(filename)));
			}
			String line;
			result = new ArrayList();
			while ((line = br.readLine()) != null) {
				result.add(line);
			}
		} finally {
			try { br.close(); } catch (Exception ee) {}
		}
		return result;
	}
	
	/**
	 * sVKɏo
	 * @param filename - t@C
	 * @param list - s
	 */
	public static void writeLines(String filename, List list) throws IOException {
		writeLines(filename, list, null, false);
	}
	
	/**
	 * sVKɏo
	 * @param filename - t@C
	 * @param encoding - GR[fBO
	 * @param list - s
	 */
	public static void writeLines(String filename, List list, String encoding) throws IOException {
		writeLines(filename, list, encoding, false);
	}
	
	/**
	 * sǉŏo
	 * @param filename - t@C
	 * @param list - s
	 */
	public static void appendLines(String filename, List list) throws IOException {
		writeLines(filename, list, null, true);
	}
	
	/**
	 * sǉŏo
	 * @param filename - t@C
	 * @param list - s
	 * @param encoding - GR[fBO
	 */
	public static void appendLines(String filename, List list, String encoding) throws IOException {
		writeLines(filename, list, encoding, true);
	}
	
	/**
	 * t@Co
	 * @param filename - t@C
	 * @param list - s
	 * @param encoding - GR[fBO
	 * @param append - ǉtO
	 * @throws IOException
	 */
	private static void writeLines(String filename, List list, String encoding, boolean append) throws IOException {
		BufferedWriter bw = null;
		try {
			if (encoding != null) {
				bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(filename, append), encoding));
			} else {
				bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(filename, append)));
			}
			for (int i = 0; i < list.size(); i++) {
				String line = (String)list.get(i);
				bw.write(line);
				bw.newLine();
			}
			bw.flush();
		} finally {
			try { if (bw != null) bw.close(); } catch (Exception ee) {}
		}
	}

	/**
	 * eLXgVKɏo
	 * @param filename - t@C
	 * @param text - eLXg
	 * @throws IOException
	 */
	public static void writeFile(String filename, String text) throws IOException {
		writeFile(filename, text, null, false);
	}

	/**
	 * eLXgVKɏo
	 * @param filename - t@C
	 * @param text - eLXg
	 * @param encoding - GR[fBO
	 * @throws IOException
	 */
	public static void writeFile(String filename, String text, String encoding) throws IOException {
		writeFile(filename, text, encoding, false);
	}

	/**
	 * eLXgǉŏo
	 * @param filename - t@C
	 * @param text - eLXg
	 * @throws IOException
	 */
	public static void appendFile(String filename, String text) throws IOException {
		writeFile(filename, text, null, true);
	}
	
	/**
	 * eLXgǉŏo
	 * @param filename - t@C
	 * @param text - eLXg
	 * @param encoding - GR[fBO
	 * @throws IOException
	 */
	public static void appendFile(String filename, String text, String encoding) throws IOException {
		writeFile(filename, text, encoding, true);
	}
	
	/**
	 * eLXgo
	 * @param filename - t@C
	 * @param text - eLXg
	 * @param encoding - GR[fBO
	 * @param append - ǉtO
	 * @throws IOException
	 */
	private static void writeFile(String filename, String text, String encoding, boolean append) throws IOException {
		BufferedWriter bw = null;
		try {
			if (encoding != null) {
				bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(filename, append), encoding));
			} else {
				bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(filename, append)));
			}
			bw.write(text);
			bw.flush();
		} finally {
			try { if (bw != null) bw.close(); } catch (Exception ee) {}
		}
	}

	/**
	 * sVKɈso
	 * @param filename - t@C
	 * @param line - s
	 * @throws IOException
	 */
	public static void writeLine(String filename, String line) throws IOException {
		writeLine(filename, line, null, false);
	}
	
	/**
	 * sVKɈso
	 * @param filename - t@C
	 * @param line - s
	 * @param encoding - GR[fBO
	 * @throws IOException
	 */
	public static void writeLine(String filename, String line, String encoding) throws IOException {
		writeLine(filename, line, encoding, false);
	}
	
	/**
	 * sǉňso
	 * @param filename - t@C
	 * @param line - s
	 * @throws IOException
	 */
	public static void appendLine(String filename, String line) throws IOException {
		writeLine(filename, line, null, true);
	}
	
	/**
	 * sǉňso
	 * @param filename - t@C
	 * @param line - s
	 * @param encoding - GR[fBO
	 * @throws IOException
	 */
	public static void appendLine(String filename, String line, String encoding) throws IOException {
		writeLine(filename, line, encoding, true);
	}
	
	/**
	 * sso
	 * @param filename - t@C
	 * @param line - s
	 * @param encoding - GR[fBO
	 * @param append - ǉtO
	 * @throws IOException
	 */
	private static void writeLine(String filename, String line, String encoding, boolean append) throws IOException {
		BufferedWriter bw = null;
		try {
			if (encoding != null) {
				bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(filename, append), encoding));
			} else {
				bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(filename, append)));
			}
			bw.write(line);
			bw.write(ln);
			bw.flush();
		} finally {
			try { if (bw != null) bw.close(); } catch (Exception ee) {}
		}
	}	
	
}
