package junkutil.set;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;

import junkutil.common.StringUtil;

/**
 * MapW_IɈB
 * @author Hiroyuki Shiota
 */
public class LzMap {
	private java.util.Map base;

	/**
	 * RXgN^
	 */
	public LzMap() {
		base = new HashMap();
	}
	/**
	 * RXgN^
	 * @param list
	 */
	public LzMap(Map map) {
		base = map;
	}
	/**
	 * RXgN^
	 * @param list
	 */
	public LzMap(Object[] keyValues) {
		if (keyValues.length % 2 != 0) throw new IllegalArgumentException();
		Map map = new HashMap();
		for (int i = 0; i < keyValues.length; i+=2) {
			map.put(keyValues[i], keyValues[i+1]);
		}
		base = map;
	}
	/**
	 * RXgN^
	 * @param list
	 */
	public LzMap(List keyValues) {
		if (keyValues.size() % 2 != 0) throw new IllegalArgumentException();
		Map map = new HashMap();
		for (int i = 0; i < keyValues.size(); i+=2) {
			map.put(keyValues.get(i), keyValues.get(i+1));
		}
		base = map;
	}
	/**
	 * RXgN^
	 * @param list
	 */
	public LzMap(Object[] keys, Object[] values) {
		if (keys.length != values.length) throw new IllegalArgumentException();
		Map map = new HashMap();
		for (int i = 0; i < keys.length; i++) {
			map.put(keys[i], values[i]);
		}
		base = map;
	}
	/**
	 * RXgN^
	 * @param list
	 */
	public LzMap(List keys, List values) {
		if (keys.size() != values.size()) throw new IllegalArgumentException();
		Map map = new HashMap();
		for (int i = 0; i < keys.size(); i++) {
			map.put(keys.get(i), values.get(i));
		}
		base = map;
	}
	/**
	 * RXgN^
	 * @param list
	 */
	public LzMap(Properties prop) {
		Map map = new HashMap();
		for (Iterator i = prop.keySet().iterator(); i.hasNext();) {
			String key = (String)i.next();
			map.put(key, prop.getProperty(key));
		}
		base = map;
	}
	
	/**
	 * L[̃XgԂ
	 * @return
	 */
	public List keys() {
		return map2keys(base);
	}
	
	/**
	 * tꂽL[̃XgԂ
	 * @return
	 */
	public List sortedKeys() {
		return new LzList(map2keys(base)).sortAsc().list();
	}
	
	/**
	 * }bṽL[̃XgԂ
	 * @param arg
	 * @return
	 */
	public static List map2keys(Map arg) {
		return Arrays.asList(arg.keySet().toArray());
	}

	/**
	 * l̃XgԂ
	 * @return
	 */
	public List values() {
		return map2values(base);
	}

	/**
	 * }bv̒l̃XgԂ
	 * @param arg
	 * @return
	 */
	public static List map2values(Map arg) {
		return Arrays.asList(arg.values().toArray());
	}

	/**
	 * }bv擾B
	 * @return
	 */
	public Map map() {
		return base;
	}
	
	/**
	 * or擾B
	 * ㏑ȂB
	 * @param arg
	 * @return
	 */
	public LzMap or(Map arg) {
		return orLeft(arg);
	}
	
	/**
	 * or擾B
	 * ㏑ȂB
	 * @param arg
	 * @return
	 */
	public LzMap orLeft(Map arg) {
		Map map = new HashMap(base);
		for (Iterator i = arg.keySet().iterator(); i.hasNext();) {
			Object key = i.next();
			if (!map.containsKey(key)) map.put(key, arg.get(key)); 
		}
		return new LzMap(map);
	}
	
	/**
	 * }[WB
	 * {@link LzMap#orRight}
	 * @param arg
	 * @return
	 */
	public LzMap marge(Map arg) {
		return orRight(arg);
	}
	
	/**
	 * or擾
	 * ̏ŏ㏑B
	 * @param arg
	 * @return
	 */
	public LzMap orRight(Map arg) {
		Map map = new HashMap(base);
		for (Iterator i = arg.keySet().iterator(); i.hasNext();) {
			Object key = i.next();
			map.put(key, arg.get(key)); 
		}
		return new LzMap(map);
	}
		
	/**
	 * and擾B
	 * nullłȂAD悷B
	 * @param arg
	 * @return
	 */
	public LzMap andLeft(Map arg) {
		Map map = new HashMap();
		List mapKeys = map2keys(base);
		List argKeys = map2keys(arg);
		List andKeys = new LzList(mapKeys).and(argKeys).list(); //ʂ̃L[
		for (Iterator i = andKeys.iterator(); i.hasNext();) {
			Object key = i.next();
			Object obj1 = base.get(key);
			Object obj2 = arg.get(key);
			if (obj1 != null) {
				map.put(key, obj1);
			} else {
				map.put(key, obj2);
			}
		}
		return new LzMap(map);
	}
		
	/**
	 * and擾B
	 * nullłȂAED悷B
	 * @param arg
	 * @return
	 */
	public LzMap andRight(Map arg) {
		Map map = new HashMap();
		List mapKeys = map2keys(base);
		List argKeys = map2keys(arg);
		List andKeys = new LzList(mapKeys).and(argKeys).list(); //ʂ̃L[
		for (Iterator i = andKeys.iterator(); i.hasNext();) {
			Object key = i.next();
			Object obj1 = base.get(key);
			Object obj2 = arg.get(key);
			if (obj2 != null) {
				map.put(key, obj2);
			} else {
				map.put(key, obj1);
			}
		}
		return new LzMap(map);
	}
		
	/**
	 * ZbgB
	 * ̃L[ɍv̂㏑B
	 * @param arg
	 * @return
	 */
	public LzMap set(Map arg) {
		Map map = new HashMap(base);
		for (Iterator i = map.keySet().iterator(); i.hasNext();) {
			Object key = i.next();
			if (arg.containsKey(key)) {
				map.put(key, arg.get(key));
			}
		}
		return new LzMap(map);
	}
	
	/**
	 * L[ƒlƂmFB
	 * @param arg
	 * @return
	 */
	public boolean equals(Map arg) {
		if (base.keySet().size() != arg.keySet().size()) return false;
		if (!new LzList(map2keys(base)).equalsOnSort(map2keys(arg))) return false; //L[
		for (Iterator i = base.keySet().iterator(); i.hasNext();) {
			Object key = i.next();
			Object obj1 = base.get(key);
			Object obj2 = arg.get(key);
			if (!obj1.equals(obj2)) return false;
		}
		return true;
	}
	
	/**
	 * TuZbg擾
	 * @param keys
	 * @return
	 */
	public LzMap subset(Object [] keys) {
		return subset(Arrays.asList(keys));
	}
	
	/**
	 * TuZbg擾
	 * @param keys
	 * @return
	 */
	public LzMap subset(List keys) {
		HashMap map = new HashMap();
		for (int i = 0; i < keys.size(); i++) {
			Object key = keys.get(i);
			if (key == null) continue;
			map.put(key, base.get(key));
		}
		return new LzMap(map);
	}
	
	/**
	 * L[gerp
	 * @param arg
	 * @retune
	 */
	public LzMap keyGrep(String re) {
		HashMap map = new HashMap();
		Pattern pattern = Pattern.compile(re);
		List keys = keys();
		for (Iterator i = keys.iterator(); i.hasNext();) {
			Object key = i.next();
			if (StringUtil.match(key.toString(), pattern)) {
				map.put(key, base.get(key));
			}
		}
		return new LzMap(map);
	}
	
	/**
	 * L[ungerp
	 * @param arg
	 * @retune
	 */
	public LzMap keyUngrep(String keyEx) {
		HashMap map = new HashMap();
		Pattern pattern = Pattern.compile(keyEx);
		List keys = keys();
		for (Iterator i = keys.iterator(); i.hasNext();) {
			Object key = i.next();
			if (!StringUtil.match(key.toString(), pattern)) {
				map.put(key, base.get(key));
			}
		}
		return new LzMap(map);
	}
	
	/**
	 * L[ƒlƂmF
	 * @param arg
	 * @return
	 */
	public boolean equals(String arg) {
		return toString().equals(arg);
	}
	
	/**
	 * 񉻂B̍ہA\[gB
	 * @Override
	 */
	public String toString() {
		List keys = sortedKeys();
		StringBuffer sb = new StringBuffer();
		sb.append("{");
		for (int i = 0; i < keys.size(); i++) {
			Object key = keys.get(i);
			Object value = base.get(key);
			if (i != 0) sb.append(" ");
			sb.append(key.toString());
			sb.append("=");
			if (value != null) {
				sb.append(value.toString());
			} else {
				sb.append("null");
			}
			if (i != keys.size() - 1) {
				sb.append(",");
			}
		}
		sb.append("}");
		return new String(sb);
	}
}
