package junkutil.text;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * K\tbNNX
 * @author Hiroyuki Shiota
 */
public class RegExpUtil {
	public String replaceBack(String str, String re, RegExpCallback callback) {
		StringBuffer result = new StringBuffer();
		Matcher m = Pattern.compile(re).matcher(str);
		int end = 0;
		while (m.find()) {
			String plainStr = str.substring(end, m.start());
			String matchStr = str.substring(m.start(), m.end());
			end = m.end();
			String replaced = callback.getReplaced(result, m);
			if (replaced != null) {
				result.append(plainStr);
				result.append(replaced);
			} else {
				result.append(plainStr);
			}
		}
		result.append(str.substring(end, str.length()));
		return new String(result);
	}
}
