package junkutil.common;

import java.util.Arrays;
import java.util.List;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junkutil.common.FileUtil;
import junkutil.set.LzList;

/**
 * FileUtileXgB
 * @author Hiroyuki Shiota
 */
public class FileUtilTest extends TestCase {
	/**
	 * RXgN^
	 * @param name
	 */
	public FileUtilTest(String name) {
		super(name);
	}

	/**
	 * @return
	 */
	public static Test suite() {
		TestSuite test = new TestSuite("FileUtilTest");
		test.addTest(new TestSuite(FileUtilTest.class));
		return test;
	}

	/**
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
	}

	/**
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
	}

	/**
	 * @throws Excepiton
	 */
	public void testExists() throws Exception {
		assertTrue(FileUtil.exists("testdata/readFile.txt"));
		assertTrue(!FileUtil.exists("testdata/readFile2.txt"));
	}
	
	/**
	 * @throws Exception
	 */
	public void testReadLines() throws Exception
	{
		List strs = Arrays.asList(new String[]{"item1","item2","item3","ACe1","ACe2","ACe3"});
		List lines1 = FileUtil.readLines("testdata/readFile.txt");
		assertTrue(new LzList(strs).equals(lines1));
		List lines2 = FileUtil.readLines("testdata/readFile.txt", "Shift_JIS");
		assertTrue(new LzList(strs).equals(lines2));
	}
	
	/**
	 * @throws Exception
	 */
	public void testWriteLines() throws Exception
	{
		List strs = Arrays.asList(new String[]{"item1","item2","item3","ACe1","ACe2","ACe3"});
		FileUtil.writeLines("testdata/writeFile.txt", strs);
		assertTrue(new LzList(strs).equals(FileUtil.readLines("testdata/writeFile.txt")));
		FileUtil.writeLines("testdata/writeUTF-8.txt", strs, "UTF-8");
		assertTrue(new LzList(strs).equals(FileUtil.readLines("testdata/writeUTF-8.txt", "UTF-8")));
	}
	
}
