package junkutil.common;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 񑀍
 * @author Hiroyuki Shiota
 */
public class StringUtil {
	private static StringUtil singleton = new StringUtil();
	private static HashMap repeatedCharsCash = new HashMap();

	/**
	 * RXgN^
	 */
	private StringUtil() {
	}
	
	/**
	 * ŏ݂̂̕uς
	 * @param target - uΏە
	 * @param search - 
	 * @param replacement - u
	 * @return u㕶
	 */
	public static String replaceFirst(String target, String search, String replacement) {
		int pos = target.indexOf(search);
		return (pos == -1)
					? target
					: target.substring(0, pos) + replacement + target.substring(pos + search.length());
	}

	/**
	 * SĂ̕u
	 * @param strValue - uΏە
	 * @param strOld - 
	 * @param strNew - u
	 * @return u㕶
	 */
	public static String replaceAll(String strValue, String strOld, String strNew) {
		int pos = 0;
		String strTemp = strValue;
		while (true) {
			pos = strTemp.indexOf(strOld, pos);
			if (pos == -1) return strTemp;
			strTemp = strTemp.substring(0, pos) + strNew + strTemp.substring(pos + strOld.length());
			pos += strOld.length();
		}
	}

	/**
	 * A
	 * @param args
	 * @param delim
	 * @return
	 */
	public static String join(String [] args, String delim) {
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < args.length; i++) {
			if (i > 0) sb.append(delim);
			sb.append(args[i]);
		}
		return new String(sb);
	}
	
	/**
	 * 𕪊
	 * @param args
	 * @param delim
	 * @return
	 */
	public static String[] split(String args, String delim) {
		List list = new ArrayList();
		int idx = 0;
		int pos = 0;
		String strTemp = args;
		while (true) {
			idx = strTemp.indexOf(delim, pos);
			if (idx == -1) {
				list.add(args.substring(pos));
				String[] retStrs = new String[list.size()];
				for (int i = 0; i < list.size(); i++) {
					retStrs[i] = (String)list.get(i);
				}
				return retStrs;
			}
			list.add(args.substring(pos, idx));
			//System.out.println(strTemp+","+idx+","+pos+"+"+list);
			pos = idx+delim.length();
			//return null;
		}
	}
	
	/**
	 * ̂݃g
	 * @param str
	 * @return trimed string
	 */
	public static String trimLeft(String str) {
		int len = str.length();
		int index = 0;
		for (int i = 0; i < len; i++) {
			char c = str.charAt(i);
			if (c != ' ') {
				index = i;
				break;
			}
		}
		return str.substring(index, len);
	}
	
	/**
	 * Ê݃g
	 * @param str
	 * @return trimed string
	 */
	public static String trimRight(String str) {
		int len = str.length();
		int index = 0;
		for (int i = len - 1; i >= 0; i--) {
			char c = str.charAt(i);
			if (c != ' ') {
				index = i+1;
				break;
			}
		}
		return str.substring(0, index);
	}
	
	/**
	 * ɋl߂̂
	 * @param str
	 * @param len
	 * @return
	 */
	public static String padLeft(String str, int len) {
		return padLeft(str, len, ' ');
	}

	/**
	 * ɋl߂̂
	 * @param str
	 * @param len
	 * @param pad
	 * @return
	 */
	public static String padLeft(String str, int len, char pad) {
		int padding_len = len - str.length();
		if (padding_len > 0) {
			return getRepeatedChars(pad, padding_len) + str;
		} else {
			return str;
		}
	}
	
	/**
	 * Eɋl߂̂
	 * @param str
	 * @param len
	 * @return
	 */
	public static String padRight(String str, int len) {
		return padRight(str, len, ' ');
	}

	/**
	 * Eɋl߂̂
	 * @param str
	 * @param len
	 * @param pad
	 * @return
	 */
	public static String padRight(String str, int len, char pad) {
		int padding_len = len - str.length();
		if (padding_len > 0) {
			return str + getRepeatedChars(pad, padding_len);
		} else {
			return str;
		}
	}
	
	/**
	 * uPbgň͂
	 * @param str
	 * @param both
	 * @return
	 */
	public static String wrapBracket(String str, String both) {
		return both + str + both;
	}
	
	/**
	 * uPbgň͂
	 * @param str
	 * @param left
	 * @param right
	 * @return
	 */
	public static String wrapBracket(String str, String left, String right) {
		return left + str + right;
	}
	
	/**
	 * uPbgO
	 * @param str
	 * @param both
	 * @return
	 */
	public static String unwrapBracket(String str, String both) {
		String result = str;
		if (result.startsWith(both)) {
			result = result.substring(both.length(), result.length());
		} else {
			return str;
		}
		if (result.endsWith(both)) {
			result = result.substring(0, result.length() - both.length());
		} else {
			return str;
		}
		return result;
	}
	
	/**
	 * uPbgO
	 * @param str
	 * @param left
	 * @param right
	 * @return
	 */
	public static String unwrapBracket(String str, String left, String right) {
		String result = str;
		if (result.startsWith(left)) {
			result = result.substring(left.length(), result.length());
		} else {
			return str;
		}
		if (result.endsWith(right)) {
			result = result.substring(0, result.length() - right.length());
		} else {
			return str;
		}
		return result;
	}
	
	/**
	 * ^uXy[Xɒu
	 * @param str
	 * @param spaceLen
	 * @return
	 */
	public static String tabToSpace(String str, int spaceLen) {
		return str.replaceAll("\t", getRepeatedSpaces(spaceLen));
	}
	
	/**
	 * Xy[X^uɒu
	 * @param str
	 * @param spaceLen
	 * @return
	 */
	public static String spaceToTab(String str, int spaceLen) {
		return str.replaceAll(getRepeatedSpaces(spaceLen), "\t");
	}
	
	/**
	 * Cӂ̒̃Xy[X擾
	 * @param len
	 * @return
	 */
	public static String getRepeatedSpaces(int len) {
		return getRepeatedChars(' ', len);
	}
	
	/**
	 * Cӂ̒̕擾
	 * @param s
	 * @param len
	 * @return
	 */
	public static String getRepeatedChars(String s, int len) {
		if (s.length() != 1) throw new IllegalArgumentException(s);
		return getRepeatedChars(s.charAt(0), len);
	}
	
	/**
	 * gCӂ̒̕擾
	 * @param c
	 * @param len
	 * @return
	 */
	public static String getRepeatedChars(char c, int len) {
		Character cobj = new Character(c);
		StringBuffer sb = null;
		if (repeatedCharsCash.containsKey(cobj)) {
			sb = (StringBuffer)repeatedCharsCash.get(cobj);
		} else {
			sb = new StringBuffer();
			repeatedCharsCash.put(cobj, sb);
		}
		int buffer_len = sb.length();
		if (buffer_len >= len) {
			return sb.substring(0, len);
		} else {
			for (int i = buffer_len; i < len; i++) {
				sb.append(c);
			}
			return sb.substring(0, len);
		}
	}
	
	/**
	 * LbVNA
	 */
	public static void clearRepeatedCharsCash() {
		repeatedCharsCash.clear();
		repeatedCharsCash = new HashMap();
	}
	
	/**
	 * n̍قeequals\bh
	 * @param str1
	 * @param str2
	 * @param err
	 * @return
	 */
	public static boolean fuzzyEquals(String str1, String str2, int err) {
		if (err<0) throw new IllegalArgumentException(); //O
		if (str1.equals(str2)) return true; //Sv
		if (Math.abs(str1.length()-str2.length()) > err) return false; //Ⴂ
		int noise = noiseCount(str1,str2, err, 0);
		//System.out.println("str1=[" + str1 + "] str2=[" + str2 + "] noise=" + noise);
		return (noise <= err);
	}
	
	/**
	 * فimCYj̐𐔂
	 * @param str1
	 * @param str2
	 * @param err
	 * @param noise
	 * @return
	 */
	private static int noiseCount(String str1, String str2, int err, int noise) {
		int maxlen = Math.max(str1.length(), str2.length());
		// v폜
		int heads = equalHeads(str1, str2);
		if (maxlen==heads) return noise; //SvȂI
		str1 = str1.substring(heads);
		str2 = str2.substring(heads);
		// Е]ĂG[ɉZ
		if (str1.length() == 0) return noise+str2.length();
		if (str2.length() == 0) return noise+str1.length();
		//System.out.println("str1=[" + str1 + "] str2=[" + str2 + "]");
		int minErr = maxlen;
		int retErr = 0;
		for (int i = -Math.min(err, str1.length()); i <= Math.min(err, str2.length()); i++) {
			if (i==0) continue;
			int slide=Math.abs(i);
			String tempstr;
			if (i<0) {
				if ((noise+slide) > err) continue;
				tempstr=str1.substring(slide);
				retErr = noiseCount(tempstr, str2, err, slide);
			} else {
				if ((noise+slide) > err) continue;
				tempstr=str2.substring(slide);
				retErr = noiseCount(str1, tempstr, err, slide);
			}
			if (retErr<minErr) {
				minErr = retErr;
			}
			//if (noise==0) System.out.print(retErr+",");
		}
		return noise+minErr;
	}
	
	private static int equalHeads(String str1, String str2) {
		int minlen = (str1.length() < str2.length()) ? str1.length() : str2.length();
		for (int i = 0; i < minlen; i++) {
			if (str1.charAt(i) != str2.charAt(i)) return i+1;
		}
		return minlen;
	}
	
	/**
	 * z𕶎ɕϊ
	 * @param args
	 * @return
	 */
	public static String toString(String [] args) {
		StringBuffer buf = new StringBuffer();
		buf.append("[");
		for (int i = 0; i < args.length; i++) {
			buf.append(args[i]);
			if (args.length == i+1) {
				buf.append("]");
			} else {
				buf.append(", ");
			}
		}
		return new String(buf);
	}
	
	/**
	 * zƔz̔r
	 * @param arg1
	 * @param arg2
	 * @return
	 */
	public static boolean equals(String[] arg1, String[] arg2) {
		if (arg1 == null) {
			if (arg2 == null) return true;
			else return false;
		} else if (arg2 == null) {
			return false;
		}
		if (arg1.length != arg2.length) return false;
		for (int i = 0; i < arg1.length; i++) {
			if (arg1[i] == null && arg2[i] != null) return false;
			if (arg1[i] != null && arg2[i] == null) return false;
			if (!arg1[i].equals(arg2[i])) return false;
		}
		return true;
	}
	
	/**
	 * URLGR[h
	 * @param str
	 * @param encode
	 * @return
	 */
	public static String urlEncode(String str) {
		return urlEncode(str, "utf-8");
	}
	
	/**
	 * URLGR[h
	 * @param str
	 * @param encode
	 * @return
	 */
	public static String urlEncode(String str, String encode) {
		try {
			return URLEncoder.encode(str, encode);
		} catch (UnsupportedEncodingException e) {
			return null;
		}
	}
	
	/**
	 * URLfR[h
	 * @param str
	 * @param encode
	 * @return
	 */
	public static String urlDecode(String str) {
		return urlDecode(str, "utf-8");
	}
	
	/**
	 * URLfR[h
	 * @param str
	 * @param encode
	 * @return
	 */
	public static String urlDecode(String str, String encode) {
		try {
			if (encode == null) encode = "utf-8";
			return URLDecoder.decode(str, encode);
		} catch (UnsupportedEncodingException e) {
			return null;
		}
	}
	
	/**
	 * HTMLGXP[v
	 * @param str
	 * @return
	 */
	public static String escapeHtml(String str) {
		str = replaceAll(str, "&",  "&amp;");
		str = replaceAll(str, "<",  "&lt;");
		str = replaceAll(str, ">",  "&gt;");
		str = replaceAll(str, "\"", "&quot;");
		str = replaceAll(str, "'", "&#39;");
		return str;
	}

	/**
	 * HTMLAGXP[v
	 * @param str
	 * @return
	 */
	public static String unescapeHtml(String str) {
		str = replaceAll(str, "&lt;",   "<");
		str = replaceAll(str, "&gt;",   ">");
		str = replaceAll(str, "&quot;", "\"");
		str = replaceAll(str, "&#39;",  "'");
		str = replaceAll(str, "&amp;",  "&");
		return str;
	}

	/**
	 * }b`
	 * @param str
	 * @param pattern
	 * @return
	 */
	public static boolean match(String str, Pattern pattern) {
		Matcher match = pattern.matcher(str);
		return match.find();
	}
	
	/**
	 * }b`
	 * @param str
	 * @param re
	 * @return
	 */
	public static boolean match(String str, String re) {
		Pattern pattern = Pattern.compile(re);
		Matcher match = pattern.matcher(str);
		return match.find();
	}
}
