package junkutil.excel;

import java.io.File;
import java.io.IOException;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junkutil.excel.ExcelUtil;

/**
 * ExcelUtileXgB
 */
public class ExcelUtilTest extends TestCase {
	/**
	 * RXgN^
	 * @param name
	 */
	public ExcelUtilTest(String name) {
		super(name);
	}

	/**
	 * @return
	 */
	public static Test suite() {
		TestSuite test = new TestSuite("ExcelUtilTest");
		test.addTest(new TestSuite(ExcelUtilTest.class));
	
		return test;
	}

	/**
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
	}

	/**
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
	}

	/**
	 * @throws Exception
	 */
	public void testWriteAndRead() throws Exception {
		writeExcel();
		readExcel();
	}

	private void writeExcel() {
		try {
			ExcelUtil excel = new ExcelUtil();
			File inFile = new File("testdata/BookInput.xls");
			if (!inFile.exists()) throw new IOException(inFile.getAbsolutePath() + " not found.");
			excel.read(inFile);
			excel.setCellNumeric(1, 0, 1);
			excel.setCellString(1, 1, "Hello, Jakarta-POI!");
			excel.setCellString(1, 2, "ɂAJakarta-POII");
			excel.createSheetAndSelect("HOGE");
			excel.setCellString(0, 0, "͐VV[gł");
			File outFile = new File("testdata/BookOutput.xls");
			excel.write(outFile);
			excel.free();
			assertTrue(true);
		} catch (Exception e) {
			e.printStackTrace();
			assertTrue(false);
		}
	}

	private void readExcel() {
		try {
			ExcelUtil excel = new ExcelUtil();
			File inFile = new File("testdata/BookOutput.xls");
			if (!inFile.exists()) throw new IOException(inFile.getAbsolutePath() + " not found.");
			excel.read(inFile);
			excel.selectSheet(0);
			assertTrue(excel.getCellNumeric(1, 0) == 1);
			assertTrue(excel.getCellString(1, 1).equals("Hello, Jakarta-POI!"));
			assertTrue(excel.getCellString(1, 2).equals("ɂAJakarta-POII"));
			excel.selectSheet("HOGE");
			assertTrue(excel.getCellString(0, 0).equals("͐VV[gł"));
			excel.free();
			assertTrue(true);
		} catch (Exception e) {
			e.printStackTrace();
			assertTrue(false);
		}
	}

}
