package junkutil.set;

import java.util.Arrays;
import java.util.List;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junkutil.set.LzList;

/**
 * LzListTesteXgB
 */
public class LzListTest extends TestCase {
	/**
	 * RXgN^
	 * @param name
	 */
	public LzListTest(String name) {
		super(name);
	}

	/**
	 * @return
	 */
	public static Test suite() {
		TestSuite test = new TestSuite("LzListTest");
		test.addTest(new TestSuite(LzListTest.class));
		return test;
	}

	/**
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
	}

	/**
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
	}

	/**
	 * @throws Exception
	 */
	public void testOr() throws Exception {
		List list = Arrays.asList(new String[]{"A", "B", "C"});
		List list2 = Arrays.asList(new String[]{"B", "C", "D", "E"});
		List or = new LzList(list).or(list2).sortAsc().list();
		assertTrue(or.toString().equals("[A, B, C, D, E]"));
	}
	
	/**
	 * @throws Exception
	 */
	public void testAnd() throws Exception {
		List list = Arrays.asList(new String[]{"A", "B", "C"});
		List list2 = Arrays.asList(new String[]{"B", "C", "D", "E"});
		List and = new LzList(list).and(list2).sortAsc().list();
		assertTrue(and.toString().equals("[B, C]"));
	}
	
	/**
	 * @throws Exception
	 */
	public void testSortAsc() throws Exception {
		List list = Arrays.asList(new String[]{"BB", "A", "CCC"});
		List asc = new LzList(list).sortAsc().list();
		assertTrue(asc.toString().equals("[A, BB, CCC]"));
	}
	
	/**
	 * @throws Exception
	 */
	public void testSortDesc() throws Exception {
		List list = Arrays.asList(new String[]{"BB", "A", "CCC"});
		List desc = new LzList(list).sortDesc().list();
		assertTrue(desc.toString().equals("[CCC, BB, A]"));
	}
	
	/**
	 * @throws Exception
	 */
	public void testJoin() throws Exception {
		List list = Arrays.asList(new String[]{"A", "B"});
		List list2 = Arrays.asList(new String[]{"B", "C"});
		List join = new LzList(list).join(list2).list();
		assertTrue(join.toString().equals("[A, B, B, C]"));
	}
	
	/**
	 * @throws Exception
	 */
	public void testUniq() throws Exception {
		List list = Arrays.asList(new String[]{"BB", "A", "CCC", "BB"});
		List uniq = new LzList(list).uniq().sortAsc().list();
		assertTrue(uniq.toString().equals("[A, BB, CCC]"));
	}

	/**
	 * @throws Exception
	 */
	public void testEquals() throws Exception {
		List list1 = Arrays.asList(new String[]{"A", "B", "C"});
		List list2 = Arrays.asList(new String[]{"A", "B", "C"});
		assertTrue(new LzList(list1).equals(list2));
	}

	/**
	 * @throws Exception
	 */
	public void testToString() throws Exception {
		assertTrue(new LzList(new String[]{"a", null, "c"}).toString().equals("[a, null, c]"));
	}
	
	/**
	 * @throws Exception
	 */
	public void testGrep() throws Exception {
		List list = Arrays.asList(new String[]{"foo", "bar", "hoge", null});;
		assertTrue(new LzList(list).grep("o").toString().equals("[foo, hoge]"));
	}
	
	/**
	 * @throws Exception
	 */
	public void testUngrep() throws Exception {
		List list = Arrays.asList(new String[]{"foo", "bar", "hoge", null});;
		assertTrue(new LzList(list).ungrep("o").toString().equals("[bar]"));
	}

}
