package junkutil.common;

import java.util.List;
import java.util.Map;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junkutil.common.DataDumper;
import junkutil.set.LzList;
import junkutil.set.LzMap;

/**
 * f[^_p[eXgB
 * @author Hiroyuki Shiota
 */
public class DataDumperTest extends TestCase {
	/**
	 * RXgN^
	 * @param name
	 */
	public DataDumperTest(String name) {
		super(name);
	}

	/**
	 * @return
	 */
	public static Test suite() {
		TestSuite test = new TestSuite("DataDumperTest");
		test.addTest(new TestSuite(DataDumperTest.class));
		return test;
	}

	/**
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
	}

	/**
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
	}

	/**
	 * @throws Exception
	 */
	public void testDumpBean() throws Exception {
		DataDumper.dumpBean(System.out, new TestBean());
		assertTrue(true);
	}
	
	/**
	 * @throws Exception
	 */
	public void testDumpException() throws Exception {
		DataDumper.dumpException(System.out, new RuntimeException("test"));
		assertTrue(true);
	}
	
	/**
	 * @throws Exception
	 */
	public void testDumpList() throws Exception {
		DataDumper.dumpList(System.out, new LzList(new Object[]{
				"item1",
				"item2",
				"item3",
				new LzMap(new Object[]{"c", new LzMap(new Object[]{"c2", "3"}).map()}).map(),
				new LzList(new Object[]{"d", "4", new LzList(new Object[]{"d2", "4", }).list()}).list()
		}).list());
		assertTrue(true);
	}
	
	/**
	 * @throws Exception
	 */
	public void testDumpByteArray() throws Exception {
		DataDumper.dumpByteArray(System.out, "1234567890".getBytes());
		assertTrue(true);
	}
	
	/**
	 * @throws Exception
	 */
	public void testDumpStrings() throws Exception {
		DataDumper.dumpStrings(System.out, new String[]{"str1", "str2", "str3"});
		assertTrue(true);
	}
	
	/**
	 * @throws Exception
	 */
	public void testDumpString() throws Exception {
		DataDumper.dumpString(System.out, "dumpString");
		assertTrue(true);
	}
	
	/**
	 * @throws Exception
	 */
	public void testDumpMap() throws Exception {
		DataDumper.dumpMap(System.out, new LzMap(new Object[]{
				"a", "1",
				"b", "2",
				"c", new LzMap(new Object[]{"c2", new LzMap(new Object[]{"c3", "3"}).map()}).map(),
				"d", new LzList(new Object[]{"d2", new LzList(new Object[]{"d3", "4"}).list()}).list()
		}).map());
		assertTrue(true);
	}
	
	/**
	 * eXgpBean
	 */
	static class TestBean {
		public TestBean() {	}
		public boolean getBoolean() { return true; }
		public int getInt() { return 123; }
		public float getFloat() { return 123.45f; }
		public double getDouble() { return 123.456d; }
		public String getString() { return "abc"; }
		public Object getObject() { return "obj"; }
		public Object getNull() { return null; }
		public boolean [] getBooleanArray() { return new boolean[]{true, false, true}; }
		public byte[] getByte() { return "123".getBytes(); }
		public int [] getIntArray() { return new int[]{1, 2, 3}; }
		public float [] getFloatArray() { return new float[]{1.11f, 2.22f, 3.33f}; }
		public double [] getDoubleArray() { return new double[]{1.111d, 2.222d, 3.333d}; }
		public String [] getStringArray() { return new String[]{"a","b","c"}; }
		public Object [] getObjectArray() { return new Object[]{new Boolean(true), new Integer(1),"abc"}; }
		public List getList() { return getLzList().list(); }
		public Map getMap() { return getLzMap().map(); }
		public LzList getLzList() { return new LzList(new String[]{"a","b","c"}); }
		public LzMap getLzMap() { return new LzMap(new String[]{"a","1","b","2","c","3"}); }
		public void setFoo() { assertTrue(false); } //Ă΂Ȃ
		public void getBar(int a) { assertTrue(false); } //Ă΂Ȃ
	}

}
